/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.localization.BentoBoxLocale;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.FileLister;
import world.bentobox.bentobox.util.Util;

public class LocalesManager {
    private final BentoBox plugin;
    private final Map<Locale, BentoBoxLocale> languages = new HashMap<Locale, BentoBoxLocale>();
    private static final String LOCALE_FOLDER = "locales";
    private static final String BENTOBOX = "BentoBox";
    private static final String SPACER = "*************************************************";
    private static final String EN_US_TAG = "en-US";

    public LocalesManager(BentoBox plugin) {
        this.plugin = plugin;
        this.copyLocalesFromPluginJar();
        this.loadLocalesFromFile(BENTOBOX);
    }

    public @Nullable String get(User user, String reference) {
        BentoBoxLocale locale;
        if (user != null && (locale = this.languages.get(user.getLocale())) != null && locale.contains(reference)) {
            return locale.get(reference);
        }
        return this.get(reference);
    }

    public String getOrDefault(User user, String reference, String defaultText) {
        BentoBoxLocale locale;
        if (user != null && (locale = this.languages.get(user.getLocale())) != null && locale.contains(reference)) {
            return locale.get(reference);
        }
        return this.getOrDefault(reference, defaultText);
    }

    public @Nullable String get(String reference) {
        if (this.languages.containsKey(Locale.forLanguageTag(this.plugin.getSettings().getDefaultLanguage())) && this.languages.get(Locale.forLanguageTag(this.plugin.getSettings().getDefaultLanguage())).contains(reference)) {
            return this.languages.get(Locale.forLanguageTag(this.plugin.getSettings().getDefaultLanguage())).get(reference);
        }
        if (this.languages.get(Locale.forLanguageTag(EN_US_TAG)).contains(reference)) {
            return this.languages.get(Locale.forLanguageTag(EN_US_TAG)).get(reference);
        }
        return null;
    }

    public boolean setTranslation(Locale locale, String reference, String translation) {
        if (!this.languages.containsKey(locale)) {
            return false;
        }
        this.languages.get(locale).set(reference, translation);
        return true;
    }

    public String getOrDefault(String reference, String defaultText) {
        String result = this.get(reference);
        return result == null ? defaultText : result;
    }

    public Set<String> getAvailablePrefixes(@NonNull User user) {
        HashSet<String> prefixes = new HashSet<String>();
        BentoBoxLocale locale = this.languages.get(user.getLocale());
        if (locale != null) {
            prefixes.addAll(locale.getPrefixes());
        }
        prefixes.addAll(this.languages.get(Locale.forLanguageTag(this.plugin.getSettings().getDefaultLanguage())).getPrefixes());
        prefixes.addAll(this.languages.get(Locale.forLanguageTag(EN_US_TAG)).getPrefixes());
        return prefixes;
    }

    void copyLocalesFromAddonJar(Addon addon) {
        try (JarFile jar = new JarFile(addon.getFile());){
            File localeDir = new File(this.plugin.getDataFolder(), LOCALE_FOLDER + File.separator + addon.getDescription().getName());
            if (!localeDir.exists()) {
                localeDir.mkdirs();
            }
            Util.listJarFiles(jar, LOCALE_FOLDER, ".yml").forEach(lf -> {
                File file = addon.saveResource((String)lf, localeDir, false, true);
                if (file != null) {
                    this.updateLocale(addon, file, (String)lf);
                }
            });
        }
        catch (Exception e) {
            this.plugin.logError(e.getMessage());
        }
    }

    private void updateLocale(Addon addon, File fileLocaleFile, String lf) {
        try {
            YamlConfiguration jarLocale = addon.getYamlFromJar(lf);
            YamlConfiguration fileLocale = new YamlConfiguration();
            fileLocale.load(fileLocaleFile);
            jarLocale.getKeys(true).stream().filter(k -> !fileLocale.contains(k, false)).forEach(k -> fileLocale.set(k, jarLocale.get(k)));
            fileLocale.save(fileLocaleFile);
        }
        catch (InvalidConfigurationException e) {
            this.plugin.logError("Could not update locale file '" + lf + "' due to it being malformed: " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.logError("Error updating locale file for " + addon.getDescription().getName() + "'s '" + lf + "': " + e.getMessage());
            this.plugin.logStacktrace(e);
        }
    }

    private void copyLocalesFromPluginJar() {
        File localeDir = new File(this.plugin.getDataFolder(), LOCALE_FOLDER + File.separator + BENTOBOX);
        if (!localeDir.exists()) {
            localeDir.mkdirs();
        }
        FileLister lister = new FileLister((Plugin)this.plugin);
        try {
            for (String name : lister.listJar(LOCALE_FOLDER)) {
                int lastIndex = name.lastIndexOf(47);
                File targetFile = new File(localeDir, name.substring(Math.max(lastIndex, 0)));
                this.copyFile(name, targetFile);
                this.updateFile(name, targetFile);
            }
        }
        catch (IOException e) {
            this.plugin.logError("Could not copy locale files from jar " + e.getMessage());
        }
    }

    private void updateFile(String name, File targetFile) throws IOException {
        try (InputStreamReader in = new InputStreamReader(this.plugin.getResource(name));){
            YamlConfiguration jarLocale = new YamlConfiguration();
            jarLocale.load((Reader)in);
            YamlConfiguration fileLocale = new YamlConfiguration();
            fileLocale.load(targetFile);
            for (String k : jarLocale.getKeys(true)) {
                if (fileLocale.contains(k, false)) continue;
                fileLocale.set(k, jarLocale.get(k));
            }
            fileLocale.save(targetFile);
        }
        catch (InvalidConfigurationException e) {
            this.plugin.logError("Could not update locale files from jar " + e.getMessage());
        }
    }

    public void loadLocalesFromFile(String localeFolder) {
        FilenameFilter ymlFilter = (dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".yml") && name.length() >= 6;
        File localeDir = new File(this.plugin.getDataFolder(), LOCALE_FOLDER + File.separator + localeFolder);
        if (!localeDir.exists()) {
            return;
        }
        for (File language : Objects.requireNonNull(localeDir.listFiles(ymlFilter))) {
            Locale localeObject = Locale.forLanguageTag(language.getName().substring(0, language.getName().length() - 4));
            try {
                YamlConfiguration languageYaml = YamlConfiguration.loadConfiguration((File)language);
                if (this.languages.containsKey(localeObject)) {
                    this.languages.get(localeObject).merge(languageYaml);
                    continue;
                }
                this.languages.put(localeObject, new BentoBoxLocale(localeObject, languageYaml));
            }
            catch (Exception e) {
                this.plugin.logError("Could not load '" + language.getName() + "' : " + e.getMessage() + " with the following cause '" + String.valueOf(e.getCause()) + "'. The file has likely an invalid YML format or has been made unreadable during the process.");
            }
        }
    }

    private void copyFile(String name, File targetFile) {
        try (InputStream initialStream = this.plugin.getResource(name);){
            if (initialStream != null && !targetFile.exists()) {
                Files.copy(initialStream, targetFile.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            this.plugin.logError("Could not copy locale files from jar " + e.getMessage());
        }
    }

    public List<Locale> getAvailableLocales(boolean sort) {
        if (sort) {
            LinkedList<Locale> locales = new LinkedList<Locale>(this.languages.keySet());
            locales.sort((locale1, locale2) -> {
                if (locale1.toLanguageTag().equals(this.plugin.getSettings().getDefaultLanguage())) {
                    return -2;
                }
                if (locale1.toLanguageTag().startsWith("en")) {
                    return -1;
                }
                if (locale1.toLanguageTag().equals(locale2.toLanguageTag())) {
                    return 0;
                }
                return 1;
            });
            return locales;
        }
        return new ArrayList<Locale>(this.languages.keySet());
    }

    public boolean isLocaleAvailable(@NonNull Locale locale) {
        return this.languages.containsKey(locale);
    }

    public Map<Locale, BentoBoxLocale> getLanguages() {
        return this.languages;
    }

    public void reloadLanguages() {
        this.languages.clear();
        this.copyLocalesFromPluginJar();
        this.loadLocalesFromFile(BENTOBOX);
        this.plugin.getAddonsManager().getAddons().forEach(addon -> {
            this.copyLocalesFromAddonJar((Addon)addon);
            this.loadLocalesFromFile(addon.getDescription().getName());
        });
    }

    public void analyzeLocales(boolean fix) {
        this.languages.clear();
        User user = User.getInstance((CommandSender)Bukkit.getConsoleSender());
        user.sendRawMessage(String.valueOf(NamedTextColor.AQUA) + SPACER);
        this.plugin.log(String.valueOf(NamedTextColor.AQUA) + "Analyzing BentoBox locale files");
        user.sendRawMessage(String.valueOf(NamedTextColor.AQUA) + SPACER);
        this.loadLocalesFromFile(BENTOBOX);
        if (this.languages.containsKey(Locale.US)) {
            this.analyze(user);
        } else {
            user.sendRawMessage(String.valueOf(NamedTextColor.RED) + "No US English in BentoBox to use for analysis!");
        }
        user.sendRawMessage(String.valueOf(NamedTextColor.AQUA) + "Analyzing Addon locale files");
        this.plugin.getAddonsManager().getAddons().forEach(addon -> {
            user.sendRawMessage(String.valueOf(NamedTextColor.AQUA) + SPACER);
            user.sendRawMessage(String.valueOf(NamedTextColor.AQUA) + "Analyzing addon " + addon.getDescription().getName());
            user.sendRawMessage(String.valueOf(NamedTextColor.AQUA) + SPACER);
            this.languages.clear();
            this.loadLocalesFromFile(addon.getDescription().getName());
            if (this.languages.containsKey(Locale.US)) {
                this.analyze(user);
            } else {
                user.sendRawMessage(String.valueOf(NamedTextColor.RED) + "No US English to use for analysis!");
            }
        });
        this.reloadLanguages();
    }

    private void analyze(User user) {
        user.sendRawMessage(String.valueOf(NamedTextColor.GREEN) + "The following locales are supported:");
        this.languages.forEach((k, v) -> user.sendRawMessage(String.valueOf(NamedTextColor.GOLD) + k.toLanguageTag() + " " + k.getDisplayLanguage() + " " + k.getDisplayCountry()));
        YamlConfiguration usConfig = this.languages.get(Locale.US).getConfig();
        YamlConfiguration fixConfig = new YamlConfiguration();
        this.languages.values().stream().filter(l -> !l.toLanguageTag().equals(Locale.US.toLanguageTag())).forEach(l -> {
            user.sendRawMessage(String.valueOf(NamedTextColor.GREEN) + SPACER);
            user.sendRawMessage(String.valueOf(NamedTextColor.GREEN) + "Analyzing locale file " + l.toLanguageTag() + ":");
            YamlConfiguration c = l.getConfig();
            boolean complete = true;
            for (String path : usConfig.getKeys(true)) {
                if (c.contains(path, true)) continue;
                complete = false;
                fixConfig.set(path, (Object)user.getTranslationOrNothing(path, new String[0]).replace('\u00a7', '&'));
            }
            if (complete) {
                user.sendRawMessage(String.valueOf(NamedTextColor.GREEN) + "Language file covers all strings.");
            } else {
                user.sendRawMessage(String.valueOf(NamedTextColor.RED) + "The following YAML is missing. Please translate it:");
                this.plugin.log("\n" + fixConfig.saveToString());
            }
        });
    }
}

