/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers.island;

import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.IslandCache;

public class IslandGrid {
    private final TreeMap<Integer, TreeMap<Integer, IslandData>> grid = new TreeMap();
    private final IslandCache im;

    public IslandGrid(IslandCache im) {
        this.im = im;
    }

    public boolean addToGrid(Island island) {
        int minX = island.getMinX();
        int minZ = island.getMinZ();
        int range = island.getRange();
        IslandData newIsland = new IslandData(island.getUniqueId(), minX, minZ, range);
        this.removeFromGrid(island);
        int newMaxX = minX + range * 2;
        int newMaxZ = minZ + range * 2;
        for (Map.Entry xEntry : this.grid.headMap(newMaxX, true).entrySet()) {
            TreeMap zMap = (TreeMap)xEntry.getValue();
            for (Map.Entry zEntry : zMap.headMap(newMaxZ, true).entrySet()) {
                IslandData existingIsland = (IslandData)zEntry.getValue();
                if (!this.isOverlapping(newIsland, existingIsland)) continue;
                return false;
            }
        }
        this.addNewEntry(minX, minZ, newIsland);
        return true;
    }

    private boolean isOverlapping(IslandData island1, IslandData island2) {
        int island1MaxX = island1.minX() + island1.range() * 2;
        int island1MaxZ = island1.minZ() + island1.range() * 2;
        int island2MaxX = island2.minX() + island2.range() * 2;
        int island2MaxZ = island2.minZ() + island2.range() * 2;
        if (island1MaxX <= island2.minX() || island2MaxX <= island1.minX()) {
            return false;
        }
        return island1MaxZ > island2.minZ() && island2MaxZ > island1.minZ();
    }

    private void addNewEntry(int minX, int minZ, IslandData islandData) {
        TreeMap zEntry = this.grid.computeIfAbsent(minX, k -> new TreeMap());
        zEntry.put(minZ, islandData);
    }

    public boolean removeFromGrid(Island island) {
        String id = island.getUniqueId();
        boolean removed = this.grid.values().stream().anyMatch(innerMap -> innerMap.values().removeIf(innerValue -> innerValue.id().equals(id)));
        this.grid.values().removeIf(AbstractMap::isEmpty);
        return removed;
    }

    public Island getIslandAt(int x, int z) {
        String id = this.getIslandStringAt(x, z);
        if (id == null) {
            return null;
        }
        return this.im.getIslandById(id);
    }

    public boolean isIslandAt(int x, int z) {
        return this.getIslandStringAt(x, z) != null;
    }

    public @Nullable String getIslandStringAt(int x, int z) {
        Map.Entry<Integer, TreeMap<Integer, IslandData>> xEntry = this.grid.floorEntry(x);
        if (xEntry == null) {
            return null;
        }
        Map.Entry<Integer, IslandData> zEntry = xEntry.getValue().floorEntry(z);
        if (zEntry == null) {
            return null;
        }
        if (x >= zEntry.getValue().minX() && x < zEntry.getValue().minX() + zEntry.getValue().range() * 2 && z >= zEntry.getValue().minZ() && z < zEntry.getValue().minZ() + zEntry.getValue().range() * 2) {
            return zEntry.getValue().id();
        }
        return null;
    }

    public long getSize() {
        long count = 0L;
        for (TreeMap<Integer, IslandData> innerMap : this.grid.values()) {
            count += (long)innerMap.size();
        }
        return count;
    }

    public TreeMap<Integer, TreeMap<Integer, IslandData>> getGrid() {
        return this.grid;
    }

    public record IslandData(String id, int minX, int minZ, int range) {
    }
}

