/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.nms;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Colorable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.database.objects.IslandDeletion;
import world.bentobox.bentobox.hooks.FancyNpcsHook;
import world.bentobox.bentobox.hooks.ItemsAdderHook;
import world.bentobox.bentobox.hooks.OraxenHook;
import world.bentobox.bentobox.hooks.SlimefunHook;
import world.bentobox.bentobox.hooks.ZNPCsPlusHook;
import world.bentobox.bentobox.nms.WorldRegenerator;
import world.bentobox.bentobox.util.MyBiomeGrid;
import world.bentobox.bentobox.util.Util;

public abstract class CopyWorldRegenerator
implements WorldRegenerator {
    private final BentoBox plugin = BentoBox.getInstance();
    private final Optional<FancyNpcsHook> npc = this.plugin.getHooks().getHook("FancyNpcs").filter(FancyNpcsHook.class::isInstance).map(FancyNpcsHook.class::cast);
    private final Optional<ZNPCsPlusHook> znpc = this.plugin.getHooks().getHook("ZNPCsPlus").filter(ZNPCsPlusHook.class::isInstance).map(ZNPCsPlusHook.class::cast);

    protected CopyWorldRegenerator() {
    }

    protected abstract void setBlockInNativeChunk(Chunk var1, int var2, int var3, int var4, BlockData var5, boolean var6);

    @Override
    public CompletableFuture<Void> regenerate(GameModeAddon gm, IslandDeletion di, World world) {
        return gm.isUsesNewChunkGeneration() ? this.regenerateCopy(gm, di, world) : this.regenerateSimple(gm, di, world);
    }

    public CompletableFuture<Void> regenerateCopy(GameModeAddon gm, final IslandDeletion di, final World world) {
        final CompletableFuture<Void> bigFuture = new CompletableFuture<Void>();
        new BukkitRunnable(){
            private int chunkX;
            private int chunkZ;
            CompletableFuture<Void> currentTask;
            {
                this.chunkX = di.getMinXChunk();
                this.chunkZ = di.getMinZChunk();
                this.currentTask = CompletableFuture.completedFuture(null);
            }

            public void run() {
                if (!this.currentTask.isDone()) {
                    return;
                }
                if (this.isEnded(this.chunkX)) {
                    this.cancel();
                    bigFuture.complete(null);
                    return;
                }
                ArrayList<CompletableFuture<Void>> newTasks = new ArrayList<CompletableFuture<Void>>();
                for (int i = 0; i < CopyWorldRegenerator.this.plugin.getSettings().getDeleteSpeed() && !this.isEnded(this.chunkX); ++i) {
                    int x = this.chunkX;
                    int z = this.chunkZ;
                    if (world.getChunkAt(x, z, false).isGenerated()) {
                        newTasks.add(CopyWorldRegenerator.this.regenerateChunk(di, world, x, z));
                    }
                    ++this.chunkZ;
                    if (this.chunkZ <= di.getMaxZChunk()) continue;
                    this.chunkZ = di.getMinZChunk();
                    ++this.chunkX;
                }
                this.currentTask = CompletableFuture.allOf(newTasks.toArray(new CompletableFuture[0]));
            }

            private boolean isEnded(int chunkX) {
                return chunkX > di.getMaxXChunk();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return bigFuture;
    }

    @Override
    public CompletableFuture<Void> regenerateChunk(Chunk chunk) {
        return this.regenerateChunk(null, chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    private CompletableFuture<Void> regenerateChunk(@Nullable IslandDeletion di, @NonNull World world, int chunkX, int chunkZ) {
        if (!world.getChunkAt(chunkX, chunkZ, false).isGenerated()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Chunk> seedWorldFuture = this.getSeedWorldChunk(world, chunkX, chunkZ);
        CompletableFuture<Chunk> chunkFuture = Util.getChunkAtAsync(world, chunkX, chunkZ);
        CompletableFuture<Object> cleanFuture = di != null ? this.cleanChunk(chunkFuture, di) : CompletableFuture.completedFuture(null);
        CompletableFuture<Void> copyFuture = CompletableFuture.allOf(cleanFuture, chunkFuture, seedWorldFuture);
        copyFuture.thenRun(() -> {
            try {
                Chunk chunkTo = (Chunk)chunkFuture.get();
                Chunk chunkFrom = (Chunk)seedWorldFuture.get();
                this.copyChunkDataToChunk(chunkTo, chunkFrom, di != null ? di.getBox() : null);
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
            }
        });
        return CompletableFuture.allOf(cleanFuture, copyFuture);
    }

    private CompletableFuture<Chunk> getSeedWorldChunk(World world, int chunkX, int chunkZ) {
        World seed = Bukkit.getWorld((String)(world.getName() + "/bentobox"));
        if (seed == null) {
            return CompletableFuture.completedFuture(null);
        }
        return Util.getChunkAtAsync(seed, chunkX, chunkZ);
    }

    private CompletableFuture<Void> cleanChunk(CompletableFuture<Chunk> chunkFuture, IslandDeletion di) {
        CompletionStage invFuture = chunkFuture.thenAccept(chunk -> Arrays.stream(chunk.getTileEntities()).filter(InventoryHolder.class::isInstance).filter(te -> di.inBounds(te.getLocation().getBlockX(), te.getLocation().getBlockZ())).forEach(te -> ((InventoryHolder)te).getInventory().clear()));
        CompletionStage entitiesFuture = chunkFuture.thenAccept(chunk -> {
            Arrays.stream(chunk.getEntities()).filter(e -> !(e instanceof Player) && di.inBounds(e.getLocation().getBlockX(), e.getLocation().getBlockZ())).forEach(Entity::remove);
            this.npc.ifPresent(hook -> hook.removeNPCsInChunk((Chunk)chunk));
            this.znpc.ifPresent(hook -> hook.removeNPCsInChunk((Chunk)chunk));
        });
        return CompletableFuture.allOf(new CompletableFuture[]{invFuture, entitiesFuture});
    }

    private void copyChunkDataToChunk(Chunk toChunk, Chunk fromChunk, BoundingBox limitBox) {
        double baseX = toChunk.getX() << 4;
        double baseZ = toChunk.getZ() << 4;
        int minHeight = toChunk.getWorld().getMinHeight();
        int maxHeight = toChunk.getWorld().getMaxHeight();
        Optional<SlimefunHook> slimefunHook = this.plugin.getHooks().getHook("Slimefun").map(SlimefunHook.class::cast);
        Optional<ItemsAdderHook> itemsAdderHook = this.plugin.getHooks().getHook("ItemsAdder").map(ItemsAdderHook.class::cast);
        Optional<Hook> oraxenHook = this.plugin.getHooks().getHook("Oraxen");
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (limitBox != null && !limitBox.contains(baseX + (double)x, 0.0, baseZ + (double)z)) continue;
                for (int y = minHeight; y < maxHeight; ++y) {
                    this.setBlockInNativeChunk(toChunk, x, y, z, fromChunk.getBlock(x, y, z).getBlockData(), false);
                    if (x % 4 == 0 && y % 4 == 0 && z % 4 == 0) {
                        toChunk.getBlock(x, y, z).setBiome(fromChunk.getBlock(x, y, z).getBiome());
                    }
                    Location loc = new Location(toChunk.getWorld(), baseX + (double)x, (double)y, baseZ + (double)z);
                    slimefunHook.ifPresent(hook -> hook.clearBlockInfo(loc, true));
                    oraxenHook.ifPresent(h -> OraxenHook.clearBlockInfo(loc));
                }
            }
        }
        itemsAdderHook.ifPresent(hook -> ItemsAdderHook.deleteAllCustomBlocksInChunk(toChunk));
        Arrays.stream(fromChunk.getEntities()).forEach(e -> this.processEntity((Entity)e, e.getLocation().toVector().toLocation(toChunk.getWorld())));
        Arrays.stream(fromChunk.getTileEntities()).forEach(bs -> this.processTileEntity(bs.getBlock(), bs.getLocation().toVector().toLocation(toChunk.getWorld()).getBlock()));
    }

    private void processEntity(Entity entity, Location location) {
        AbstractHorse horse2;
        AbstractHorse horse;
        Entity bpe = location.getWorld().spawnEntity(location, entity.getType());
        bpe.setCustomName(entity.getCustomName());
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (bpe instanceof Villager) {
                Villager villager2 = (Villager)bpe;
                this.setVillager(villager, villager2);
            }
        }
        if (entity instanceof Colorable) {
            Colorable c = (Colorable)entity;
            if (bpe instanceof Colorable) {
                Colorable cc = (Colorable)bpe;
                if (c.getColor() != null) {
                    cc.setColor(c.getColor());
                }
            }
        }
        if (entity instanceof Tameable) {
            Tameable t = (Tameable)entity;
            if (bpe instanceof Tameable) {
                Tameable tt = (Tameable)bpe;
                tt.setTamed(t.isTamed());
            }
        }
        if (entity instanceof ChestedHorse) {
            ChestedHorse ch = (ChestedHorse)entity;
            if (bpe instanceof ChestedHorse) {
                ChestedHorse ch2 = (ChestedHorse)bpe;
                ch2.setCarryingChest(ch.isCarryingChest());
            }
        }
        if (entity instanceof Ageable) {
            Ageable a = (Ageable)entity;
            if (bpe instanceof Ageable) {
                Ageable aa = (Ageable)bpe;
                if (a.isAdult()) {
                    aa.setAdult();
                }
            }
        }
        if (entity instanceof AbstractHorse) {
            horse = (AbstractHorse)entity;
            if (bpe instanceof AbstractHorse) {
                horse2 = (AbstractHorse)bpe;
                horse2.setDomestication(horse.getDomestication());
                horse2.getInventory().setContents(horse.getInventory().getContents());
            }
        }
        if (entity instanceof Horse) {
            horse = (Horse)entity;
            if (bpe instanceof Horse) {
                horse2 = (Horse)bpe;
                horse2.setStyle(horse.getStyle());
            }
        }
    }

    private void setVillager(Villager v, Villager villager2) {
        villager2.setVillagerExperience(v.getVillagerExperience());
        villager2.setVillagerLevel(v.getVillagerLevel());
        villager2.setProfession(v.getProfession());
        villager2.setVillagerType(v.getVillagerType());
    }

    private void processTileEntity(Block fromBlock, Block toBlock) {
        BlockState blockState = fromBlock.getState();
        BlockState b = toBlock.getState();
        BlockState blockState2 = blockState;
        Objects.requireNonNull(blockState2);
        BlockState blockState3 = blockState2;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Sign.class, InventoryHolder.class, CreatureSpawner.class, Banner.class}, (Object)blockState3, n)) {
                case 0: {
                    Sign fromSign = (Sign)blockState3;
                    if (!(b instanceof Sign)) {
                        n = 1;
                        continue block6;
                    }
                    Sign toSign = (Sign)b;
                    for (Side side : Side.values()) {
                        this.writeSign(fromSign, toSign, side);
                    }
                    break block6;
                }
                case 1: {
                    InventoryHolder ih = (InventoryHolder)blockState3;
                    if (!(b instanceof InventoryHolder)) {
                        n = 2;
                        continue block6;
                    }
                    InventoryHolder toChest = (InventoryHolder)b;
                    toChest.getInventory().setContents(ih.getInventory().getContents());
                    break block6;
                }
                case 2: {
                    CreatureSpawner spawner = (CreatureSpawner)blockState3;
                    if (!(b instanceof CreatureSpawner)) {
                        n = 3;
                        continue block6;
                    }
                    CreatureSpawner toSpawner = (CreatureSpawner)b;
                    toSpawner.setSpawnedType(spawner.getSpawnedType());
                    break block6;
                }
                case 3: {
                    Banner banner = (Banner)blockState3;
                    if (!(b instanceof Banner)) {
                        n = 4;
                        continue block6;
                    }
                    Banner toBanner = (Banner)b;
                    toBanner.setBaseColor(banner.getBaseColor());
                    toBanner.setPatterns(banner.getPatterns());
                    break block6;
                }
            }
            break;
        }
    }

    private void writeSign(Sign fromSign, Sign toSign, Side side) {
        SignSide fromSide = fromSign.getSide(side);
        SignSide toSide = toSign.getSide(side);
        int i = 0;
        for (Component line : fromSide.lines()) {
            toSide.line(i++, line);
        }
        toSide.setGlowingText(fromSide.isGlowingText());
    }

    public CompletableFuture<Void> regenerateSimple(final GameModeAddon gm, final IslandDeletion di, final World world) {
        final CompletableFuture<Void> bigFuture = new CompletableFuture<Void>();
        if (world == null) {
            bigFuture.complete(null);
            return bigFuture;
        }
        new BukkitRunnable(){
            private int chunkX;
            private int chunkZ;
            CompletableFuture<Void> currentTask;
            {
                this.chunkX = di.getMinXChunk();
                this.chunkZ = di.getMinZChunk();
                this.currentTask = CompletableFuture.completedFuture(null);
            }

            public void run() {
                if (!this.currentTask.isDone()) {
                    return;
                }
                if (this.isEnded(this.chunkX)) {
                    this.cancel();
                    bigFuture.complete(null);
                    return;
                }
                ArrayList<CompletableFuture<Void>> newTasks = new ArrayList<CompletableFuture<Void>>();
                for (int i = 0; i < CopyWorldRegenerator.this.plugin.getSettings().getDeleteSpeed() && !this.isEnded(this.chunkX); ++i) {
                    int x = this.chunkX++;
                    int z = this.chunkZ++;
                    newTasks.add(CopyWorldRegenerator.this.regenerateChunk(gm, di, world, x, z));
                    if (this.chunkZ <= di.getMaxZChunk()) continue;
                    this.chunkZ = di.getMinZChunk();
                }
                this.currentTask = CompletableFuture.allOf(newTasks.toArray(new CompletableFuture[0]));
            }

            private boolean isEnded(int chunkX) {
                return chunkX > di.getMaxXChunk();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return bigFuture;
    }

    private CompletableFuture<Void> regenerateChunk(GameModeAddon gm, IslandDeletion di, @Nonnull World world, int chunkX, int chunkZ) {
        CompletableFuture<Chunk> chunkFuture = Util.getChunkAtAsync(world, chunkX, chunkZ);
        CompletionStage invFuture = chunkFuture.thenAccept(chunk -> Arrays.stream(chunk.getTileEntities()).filter(InventoryHolder.class::isInstance).filter(te -> di.inBounds(te.getLocation().getBlockX(), te.getLocation().getBlockZ())).forEach(te -> ((InventoryHolder)te).getInventory().clear()));
        CompletionStage entitiesFuture = chunkFuture.thenAccept(chunk -> {
            for (Entity e : chunk.getEntities()) {
                if (e instanceof Player) continue;
                e.remove();
            }
        });
        CompletionStage copyFuture = chunkFuture.thenApply(chunk -> {
            MyBiomeGrid grid = new MyBiomeGrid(chunk.getWorld().getEnvironment());
            ChunkGenerator cg = gm.getDefaultWorldGenerator(chunk.getWorld().getName(), "delete");
            if (cg != null) {
                ChunkGenerator.ChunkData cd = cg.generateChunkData(chunk.getWorld(), new Random(), chunk.getX(), chunk.getZ(), (ChunkGenerator.BiomeGrid)grid);
                this.copyChunkDataToChunk((Chunk)chunk, cd, grid, di.getBox());
            }
            return chunk;
        });
        CompletionStage postCopyFuture = ((CompletableFuture)copyFuture).thenAccept(chunk -> Arrays.stream(chunk.getEntities()).filter(e -> !(e instanceof Player) && di.inBounds(e.getLocation().getBlockX(), e.getLocation().getBlockZ())).forEach(Entity::remove));
        return CompletableFuture.allOf(new CompletableFuture[]{invFuture, entitiesFuture, postCopyFuture});
    }

    private void copyChunkDataToChunk(Chunk chunk, ChunkGenerator.ChunkData chunkData, ChunkGenerator.BiomeGrid biomeGrid, BoundingBox limitBox) {
        double baseX = chunk.getX() << 4;
        double baseZ = chunk.getZ() << 4;
        int minHeight = chunk.getWorld().getMinHeight();
        int maxHeight = chunk.getWorld().getMaxHeight();
        Optional<Hook> slimefunHook = this.plugin.getHooks().getHook("Slimefun");
        Optional<Hook> oraxenHook = this.plugin.getHooks().getHook("Oraxen");
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!limitBox.contains(baseX + (double)x, 0.0, baseZ + (double)z)) continue;
                for (int y = minHeight; y < maxHeight; ++y) {
                    this.setBlockInNativeChunk(chunk, x, y, z, chunkData.getBlockData(x, y, z), false);
                    if (x % 4 == 0 && y % 4 == 0 && z % 4 == 0) {
                        chunk.getBlock(x, y, z).setBiome(biomeGrid.getBiome(x, y, z));
                    }
                    Location loc = new Location(chunk.getWorld(), baseX + (double)x, (double)y, baseZ + (double)z);
                    slimefunHook.ifPresent(sf -> ((SlimefunHook)sf).clearBlockInfo(loc, true));
                    oraxenHook.ifPresent(h -> OraxenHook.clearBlockInfo(loc));
                }
            }
        }
        this.plugin.getHooks().getHook("ItemsAdder").ifPresent(hook -> ItemsAdderHook.deleteAllCustomBlocksInChunk(chunk));
    }
}

