/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.database.objects.IslandDeletion;
import world.bentobox.bentobox.nms.WorldRegenerator;
import world.bentobox.bentobox.util.Util;

public class DeleteIslandChunks {
    private final IslandDeletion di;
    private final BentoBox plugin;
    private final World netherWorld;
    private final World endWorld;
    private final AtomicBoolean completed;
    private final WorldRegenerator regenerator;

    public DeleteIslandChunks(BentoBox plugin, IslandDeletion di) {
        this.plugin = plugin;
        this.di = di;
        this.completed = new AtomicBoolean(false);
        this.netherWorld = plugin.getIWM().isNetherGenerate(di.getWorld()) && plugin.getIWM().isNetherIslands(di.getWorld()) ? plugin.getIWM().getNetherWorld(di.getWorld()) : null;
        this.endWorld = plugin.getIWM().isEndGenerate(di.getWorld()) && plugin.getIWM().isEndIslands(di.getWorld()) ? plugin.getIWM().getEndWorld(di.getWorld()) : null;
        this.regenerator = Util.getRegenerator();
        if (this.regenerator == null) {
            plugin.logError("Could not delete chunks because of NMS error");
            return;
        }
        IslandEvent.builder().deletedIslandInfo(di).reason(IslandEvent.Reason.DELETE_CHUNKS).build();
        this.regenerateChunks();
    }

    private void regenerateChunks() {
        final CompletableFuture all = this.plugin.getIWM().getAddon(this.di.getWorld()).map(gm -> new CompletableFuture[]{this.processWorld((GameModeAddon)gm, this.di.getWorld()), this.processWorld((GameModeAddon)gm, this.netherWorld), this.processWorld((GameModeAddon)gm, this.endWorld)}).map(CompletableFuture::allOf).orElseGet(() -> CompletableFuture.completedFuture(null));
        new BukkitRunnable(){

            public void run() {
                if (all.isDone()) {
                    DeleteIslandChunks.this.finish();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void finish() {
        IslandEvent.builder().deletedIslandInfo(this.di).reason(IslandEvent.Reason.DELETED).build();
        this.completed.set(true);
    }

    private CompletableFuture<Void> processWorld(GameModeAddon gm, World world) {
        if (world != null) {
            return this.regenerator.regenerate(gm, this.di, world);
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isCompleted() {
        return this.completed.get();
    }
}

