/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminBlueprintDeleteCommand
extends ConfirmableCommand {
    public AdminBlueprintDeleteCommand(AdminBlueprintCommand parent) {
        super(parent, "delete", "remove");
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.delete");
        this.setParametersHelp("commands.admin.blueprint.delete.parameters");
        this.setDescription("commands.admin.blueprint.delete.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        String blueprintName = Util.sanitizeInput(args.getFirst());
        if (this.getPlugin().getBlueprintsManager().getBlueprints((GameModeAddon)this.getAddon()).containsKey(blueprintName)) {
            this.askConfirmation(user, user.getTranslation("commands.admin.blueprint.delete.confirmation", new String[0]), () -> {
                this.getPlugin().getBlueprintsManager().deleteBlueprint((GameModeAddon)this.getAddon(), blueprintName);
                user.sendMessage("commands.admin.blueprint.delete.success", "[name]", blueprintName);
            });
            return true;
        }
        user.sendMessage("commands.admin.blueprint.delete.no-blueprint", "[name]", blueprintName);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return Optional.of(new LinkedList<String>(this.getPlugin().getBlueprintsManager().getBlueprints((GameModeAddon)this.getAddon()).keySet()));
    }
}

