/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.util.List;
import java.util.Optional;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.BlueprintClipboard;

public class AdminBlueprintSinkCommand
extends CompositeCommand {
    public AdminBlueprintSinkCommand(AdminBlueprintCommand parent) {
        super(parent, "sink", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.sink");
        this.setDescription("commands.admin.blueprint.sink.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        if (args.isEmpty()) {
            BlueprintClipboard clipboard = parent.getClipboards().computeIfAbsent(user.getUniqueId(), v -> new BlueprintClipboard());
            if (clipboard.isFull()) {
                assert (clipboard.getBlueprint() != null);
                clipboard.getBlueprint().setSink(!clipboard.getBlueprint().isSink());
                user.sendMessage("commands.admin.blueprint.sink.status", "[status]", clipboard.getBlueprint().isSink() ? user.getTranslation("commands.admin.blueprint.sink.sink", new String[0]) : user.getTranslation("commands.admin.blueprint.sink.not-sink", new String[0]));
                return true;
            }
            user.sendMessage("commands.admin.blueprint.sink.no-clipboard", new String[0]);
            return false;
        }
        this.showHelp(this, user);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return Optional.of(List.of("air", "biome", "nowater", "sink"));
    }
}

