/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.deaths;

import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.deaths.AdminDeathsCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminDeathsResetCommand
extends CompositeCommand {
    public AdminDeathsResetCommand(AdminDeathsCommand parent) {
        super(parent, "reset", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.deaths.reset");
        this.setDescription("commands.admin.deaths.reset.description");
        this.setParametersHelp("commands.admin.deaths.reset.parameters");
    }

    @Override
    public boolean execute(User user, String label, @NonNull List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = Util.getUUID(args.getFirst());
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        this.getPlayers().setDeaths(this.getWorld(), targetUUID, 0);
        user.sendMessage("commands.admin.deaths.reset.success", "[name]", args.getFirst());
        return true;
    }
}

