/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.localization;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.util.ItemParser;

public class BentoBoxLocale {
    private static final String UNKNOWN = "unknown";
    private final Locale locale;
    private final YamlConfiguration config;
    private final ItemStack banner;
    private final List<String> authors;
    private final Set<String> prefixes;

    public BentoBoxLocale(Locale locale, YamlConfiguration config) {
        this.locale = locale;
        this.config = config;
        this.banner = ItemParser.parse(config.getString("meta.banner"));
        this.authors = new LinkedList<String>();
        this.updateAuthors(config);
        this.prefixes = new HashSet<String>();
        this.updatePrefixes(config);
    }

    public String get(String reference) {
        Object obj = this.config.get(reference);
        if (obj instanceof String) {
            return obj.toString();
        }
        return reference;
    }

    public String getLanguage() {
        if (this.locale == null) {
            return UNKNOWN;
        }
        return this.locale.getDisplayLanguage();
    }

    public String getCountry() {
        if (this.locale == null) {
            return UNKNOWN;
        }
        return this.locale.getDisplayCountry();
    }

    public String toLanguageTag() {
        if (this.locale == null) {
            return UNKNOWN;
        }
        return this.locale.toLanguageTag();
    }

    public ItemStack getBanner() {
        return this.banner;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void merge(@NonNull YamlConfiguration toBeMerged) {
        for (String key : toBeMerged.getKeys(true)) {
            if (key.startsWith("meta") || this.config.contains(key)) continue;
            this.config.set(key, toBeMerged.get(key));
        }
        this.updateAuthors(toBeMerged);
        this.updatePrefixes(toBeMerged);
    }

    public void set(@NonNull String reference, @NonNull String value) {
        this.config.set(reference, (Object)value);
    }

    public boolean contains(String reference) {
        return this.config.contains(reference);
    }

    private void updateAuthors(YamlConfiguration yamlConfiguration) {
        List list = yamlConfiguration.getStringList("meta.authors");
        if (!list.isEmpty()) {
            for (String author : list) {
                if (this.authors.contains(author)) continue;
                this.authors.add(author);
            }
        }
    }

    private void updatePrefixes(YamlConfiguration yamlConfiguration) {
        ConfigurationSection prefixesConfigSection = yamlConfiguration.getConfigurationSection("prefixes");
        if (prefixesConfigSection != null) {
            this.prefixes.addAll(prefixesConfigSection.getKeys(false));
        }
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public @NonNull Set<String> getPrefixes() {
        return this.prefixes;
    }
}

