/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.database.DatabaseConnector;

public abstract class AbstractDatabaseHandler<T> {
    protected Queue<Runnable> processQueue;
    private BukkitTask asyncSaveTask;
    private boolean inSave;
    protected boolean shutdown;
    protected static final String DATABASE_FOLDER_NAME = "database";
    protected Class<T> dataObject;
    protected DatabaseConnector databaseConnector;
    protected BentoBox plugin;
    private @Nullable Addon addon;

    public @Nullable Addon getAddon() {
        return this.addon;
    }

    public void setAddon(@Nullable Addon addon) {
        this.addon = addon;
    }

    protected AbstractDatabaseHandler(BentoBox plugin, Class<T> type, DatabaseConnector databaseConnector) {
        this.plugin = plugin;
        this.databaseConnector = databaseConnector;
        this.dataObject = type;
        if (!plugin.isEnabled()) {
            return;
        }
        this.processQueue = new ConcurrentLinkedQueue<Runnable>();
        this.asyncSaveTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> {
            if (this.shutdown || plugin.isShutdown()) {
                databaseConnector.closeConnection(this.dataObject);
                this.asyncSaveTask.cancel();
            } else if (!this.inSave && !this.processQueue.isEmpty()) {
                this.inSave = true;
                while (!this.processQueue.isEmpty()) {
                    this.processQueue.poll().run();
                }
                this.inSave = false;
            }
        }, 0L, 1L);
    }

    protected AbstractDatabaseHandler() {
    }

    public abstract List<T> loadObjects() throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IntrospectionException, NoSuchMethodException;

    public abstract @Nullable T loadObject(@NonNull String var1) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, IntrospectionException, NoSuchMethodException;

    public CompletableFuture<List<T>> loadObjectsASync() {
        CompletableFuture<List<T>> completableFuture = new CompletableFuture<List<T>>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BentoBox.getInstance(), () -> {
            try {
                completableFuture.complete(this.loadObjects());
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
                this.plugin.logError("Failed to load objects asynchronously: " + e.getMessage());
            }
        });
        return completableFuture;
    }

    public abstract CompletableFuture<Boolean> saveObject(T var1) throws IllegalAccessException, InvocationTargetException, IntrospectionException;

    public abstract void deleteObject(T var1) throws IllegalAccessException, InvocationTargetException, IntrospectionException;

    public abstract boolean objectExists(String var1);

    public abstract void close();

    public abstract void deleteID(String var1);
}

