/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.database.AbstractDatabaseHandler;
import world.bentobox.bentobox.database.DatabaseSetup;
import world.bentobox.bentobox.database.objects.DataObject;

public class Database<T> {
    private final AbstractDatabaseHandler<T> handler;
    private final Logger logger;
    private static DatabaseSetup databaseSetup = DatabaseSetup.getDatabase();
    private static final Set<Class<? extends DataObject>> dataObjects = new HashSet<Class<? extends DataObject>>();

    public Database(BentoBox plugin, Class<T> type) {
        this.logger = plugin.getLogger();
        this.handler = databaseSetup.getHandler(type);
        dataObjects.add(type);
    }

    public Database(Addon addon, Class<T> type) {
        this.logger = addon.getLogger();
        this.handler = databaseSetup.getHandler(type);
        dataObjects.add(type);
    }

    public @NonNull List<T> loadObjects() {
        List<Object> result = new ArrayList();
        try {
            result = this.handler.loadObjects();
        }
        catch (IntrospectionException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.severe(() -> "Could not load objects from database! Error: " + e.getMessage());
        }
        return result;
    }

    public @Nullable T loadObject(String uniqueId) {
        T result = null;
        try {
            result = this.handler.loadObject(uniqueId);
        }
        catch (IntrospectionException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            this.logger.severe(() -> "Could not load object from database! " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.logger.severe(() -> "Could not load object from database! " + e.getMessage());
            this.logger.severe(() -> "Did you forget the JavaBean no-arg default constructor?");
        }
        return result;
    }

    public CompletableFuture<Boolean> saveObjectAsync(T instance) {
        try {
            return this.handler.saveObject(instance);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.severe(() -> "Could not save object to database! Error: " + e.getMessage());
            return new CompletableFuture<Boolean>();
        }
    }

    public boolean saveObject(T instance) {
        this.saveObjectAsync(instance).thenAccept(r -> {
            if (Boolean.FALSE.equals(r)) {
                this.logger.severe(() -> "Could not save object to database!");
            }
        });
        return true;
    }

    public boolean objectExists(String name) {
        return this.handler.objectExists(name);
    }

    public void deleteID(String uniqueId) {
        this.handler.deleteID(uniqueId);
    }

    public void deleteObject(T object) {
        try {
            this.handler.deleteObject(object);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.severe(() -> "Could not delete object! Error: " + e.getMessage());
        }
    }

    public void close() {
        this.handler.close();
    }

    public static Set<Class<? extends DataObject>> getDataobjects() {
        return dataObjects;
    }

    public @NonNull CompletableFuture<List<T>> loadObjectsASync() {
        return this.handler.loadObjectsASync();
    }
}

