/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.objects;

import com.google.gson.annotations.Expose;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.Table;

@Table(name="IslandDeletion")
public class IslandDeletion
implements DataObject {
    @Expose
    private String uniqueId = "";
    @Expose
    private Location location;
    @Expose
    private int minXChunk;
    @Expose
    private int maxXChunk;
    @Expose
    private int minZChunk;
    @Expose
    private int maxZChunk;
    @Expose
    private int minX;
    @Expose
    private int minZ;
    @Expose
    private int maxX;
    @Expose
    private int maxZ;
    @Expose
    BoundingBox box;

    public IslandDeletion() {
    }

    public IslandDeletion(Island island) {
        int range = Math.min(island.getMaxEverProtectionRange(), island.getRange());
        this.uniqueId = UUID.randomUUID().toString();
        this.location = island.getCenter();
        this.minX = this.location.getBlockX() - range;
        this.minXChunk = this.minX >> 4;
        this.maxX = range + this.location.getBlockX();
        this.maxXChunk = this.maxX >> 4;
        this.minZ = this.location.getBlockZ() - range;
        this.minZChunk = this.minZ >> 4;
        this.maxZ = range + this.location.getBlockZ();
        this.maxZChunk = this.maxZ >> 4;
        this.box = island.getBoundingBox();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IslandDeletion)) {
            return false;
        }
        IslandDeletion other = (IslandDeletion)obj;
        if (this.uniqueId == null) {
            return other.uniqueId == null;
        }
        return this.uniqueId.equals(other.uniqueId);
    }

    public Location getLocation() {
        return this.location;
    }

    public int getMaxXChunk() {
        return this.maxXChunk;
    }

    public int getMaxZChunk() {
        return this.maxZChunk;
    }

    public int getMinXChunk() {
        return this.minXChunk;
    }

    public int getMinZChunk() {
        return this.minZChunk;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public World getWorld() {
        return this.location.getWorld();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uniqueId == null ? 0 : this.uniqueId.hashCode());
        return result;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setMaxXChunk(int maxXChunk) {
        this.maxXChunk = maxXChunk;
    }

    public void setMaxZChunk(int maxZChunk) {
        this.maxZChunk = maxZChunk;
    }

    public void setMinXChunk(int minXChunk) {
        this.minXChunk = minXChunk;
    }

    public void setMinZChunk(int minZChunk) {
        this.minZChunk = minZChunk;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public void setMinZ(int minZ) {
        this.minZ = minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(int maxZ) {
        this.maxZ = maxZ;
    }

    @Override
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean inBounds(int x, int z) {
        return this.box.contains(new Vector(x, 0, z));
    }

    public BoundingBox getBox() {
        return this.box;
    }

    public void setBox(BoundingBox box) {
        this.box = box;
    }

    public String toString() {
        return "IslandDeletion [uniqueId=" + this.uniqueId + ", location=" + String.valueOf(this.location) + ", minXChunk=" + this.minXChunk + ", maxXChunk=" + this.maxXChunk + ", minZChunk=" + this.minZChunk + ", maxZChunk=" + this.maxZChunk + ", minX=" + this.minX + ", minZ=" + this.minZ + ", maxX=" + this.maxX + ", maxZ=" + this.maxZ + ", box=" + String.valueOf(this.box) + "]";
    }
}

