/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.yaml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.UUID;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.database.DatabaseConnector;

public class YamlDatabaseConnector
implements DatabaseConnector {
    private static final int MAX_LOOPS = 100;
    private static final String DATABASE_FOLDER_NAME = "database";
    private static final String YML = ".yml";
    private final BentoBox plugin;
    private final File dataFolder;

    YamlDatabaseConnector(BentoBox plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), DATABASE_FOLDER_NAME);
    }

    @Override
    public String getConnectionUrl() {
        return null;
    }

    public YamlConfiguration loadYamlFile(String tableName, String fileName) {
        YamlConfiguration config;
        block12: {
            if (!((String)fileName).endsWith(YML)) {
                fileName = (String)fileName + YML;
            }
            File yamlFile = new File(this.plugin.getDataFolder(), tableName + File.separator + (String)fileName);
            config = null;
            if (yamlFile.exists()) {
                try {
                    config = new YamlConfiguration();
                    config.load(yamlFile);
                }
                catch (Exception e) {
                    if (e.getMessage().contains("!!java.util.UUID")) {
                        this.removeStringFromFile(yamlFile);
                        try {
                            Objects.requireNonNull(config).load(yamlFile);
                        }
                        catch (IOException | InvalidConfigurationException e1) {
                            this.plugin.logError("Could not load yml file from database " + tableName + " " + (String)fileName + " " + e.getMessage());
                        }
                        break block12;
                    }
                    this.plugin.logError("Could not load yml file from database " + tableName + " " + (String)fileName + " " + e.getMessage());
                }
            } else {
                config = new YamlConfiguration();
                this.plugin.log("No " + (String)fileName + " found. Creating it...");
                try {
                    if (this.plugin.getResource((String)fileName) != null) {
                        this.plugin.log("Using default found in jar file.");
                        this.plugin.saveResource((String)fileName, false);
                        config = new YamlConfiguration();
                        config.load(yamlFile);
                    } else {
                        config.save(yamlFile);
                    }
                }
                catch (Exception e) {
                    this.plugin.logError("Could not create the " + (String)fileName + " file!");
                }
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStringFromFile(File yamlFile) {
        try (PrintWriter writer = null;
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(yamlFile), StandardCharsets.UTF_8));){
            File temp = File.createTempFile("file", ".tmp", yamlFile.getParentFile());
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                line = line.replace("!!java.util.UUID", "");
                writer.println(line);
                line = reader.readLine();
            }
            Files.delete(yamlFile.toPath());
            if (!temp.renameTo(yamlFile)) {
                this.plugin.logError("Could not rename fixed Island object. Are the writing permissions correctly setup?");
            }
        }
    }

    boolean saveYamlFile(String data, String tableName, String fileName, Map<String, String> commentMap) {
        Object name = fileName.endsWith(YML) ? fileName : fileName + YML;
        File tableFolder = new File(this.plugin.getDataFolder(), tableName);
        File file = new File(tableFolder, (String)name);
        if (!tableFolder.exists()) {
            tableFolder.mkdirs();
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(data);
        }
        catch (IOException e) {
            this.plugin.logError("Could not save yml file: " + tableName + " " + fileName + " " + e.getMessage());
            return false;
        }
        if (commentMap != null && !commentMap.isEmpty()) {
            this.commentFile(new File(tableFolder, (String)name), commentMap);
        }
        return true;
    }

    private void commentFile(File file, Map<String, String> commentMap) {
        File commentedFile = new File(file.getPath() + ".tmp");
        ArrayList<String> newFile = new ArrayList<String>();
        try (Scanner scanner = new Scanner(file, StandardCharsets.UTF_8);){
            while (scanner.hasNextLine()) {
                Object nextLine = scanner.nextLine();
                for (Map.Entry<String, String> e : commentMap.entrySet()) {
                    if (!((String)nextLine).contains(e.getKey())) continue;
                    nextLine = " ".repeat(Math.max(0, ((String)nextLine).indexOf(e.getKey()))) + e.getValue();
                    break;
                }
                newFile.add((String)nextLine);
            }
            Files.write(commentedFile.toPath(), newFile.stream()::iterator, new OpenOption[0]);
            this.copyFileUsingStream(commentedFile, file);
            Files.delete(commentedFile.toPath());
        }
        catch (IOException e1) {
            this.plugin.logError("Could not comment config file " + file.getName() + " " + e1.getMessage());
            this.plugin.logStacktrace(e1);
        }
    }

    private void copyFileUsingStream(File source, File dest) throws IOException {
        try (FileInputStream is = new FileInputStream(source);
             FileOutputStream os = new FileOutputStream(dest);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
    }

    @Override
    public @NonNull String getUniqueId(String tableName) {
        UUID uuid = UUID.randomUUID();
        File file = new File(this.dataFolder, tableName + File.separator + String.valueOf(uuid) + YML);
        int limit = 0;
        while (file.exists() && limit++ < 100) {
            uuid = UUID.randomUUID();
            file = new File(this.dataFolder, tableName + File.separator + String.valueOf(uuid) + YML);
        }
        return uuid.toString();
    }

    @Override
    public boolean uniqueIdExists(String tableName, String key) {
        File file = new File(this.dataFolder, tableName + File.separator + key + YML);
        return file.exists();
    }

    @Override
    public Object createConnection(Class<?> type) {
        return null;
    }

    @Override
    public void closeConnection(Class<?> type) {
    }
}

