/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.hooks;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.utils.drops.Drop;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.hooks.Hook;

public class OraxenHook
extends Hook {
    public OraxenHook(BentoBox plugin) {
        super("Oraxen", Material.ORANGE_BANNER);
    }

    @Override
    public boolean hook() {
        return Bukkit.getPluginManager().getPlugin("Oraxen") != null;
    }

    public static void clearBlockInfo(Location location) {
        OraxenBlocks.remove((Location)location, null, null);
    }

    public static Optional<String> getNamespacedId(ItemStack myItemStack) {
        return Optional.ofNullable(OraxenItems.getIdByItem((ItemStack)myItemStack));
    }

    public static Set<String> getBlockIDs() {
        return OraxenBlocks.getBlockIDs();
    }

    public static Set<String> getNoteBlockIDs() {
        return OraxenBlocks.getNoteBlockIDs();
    }

    public static Set<String> getStringBlockIDs() {
        return OraxenBlocks.getStringBlockIDs();
    }

    public static boolean isOraxenBlock(Block block) {
        return OraxenBlocks.isOraxenBlock((Block)block);
    }

    public static Mechanic getOraxenBlock(Location location) {
        return OraxenBlocks.getOraxenBlock((Location)location);
    }

    public static String getOraxenBlockID(Location location) {
        Mechanic m = OraxenHook.getOraxenBlock(location);
        return m == null ? null : m.getItemID();
    }

    public static Mechanic getOraxenBlock(BlockData blockData) {
        return OraxenBlocks.getOraxenBlock((BlockData)blockData);
    }

    public static NoteBlockMechanic getNoteBlockMechanic(BlockData data) {
        return OraxenBlocks.getNoteBlockMechanic((BlockData)data);
    }

    public static NoteBlockMechanic getNoteBlockMechanic(Block block) {
        return OraxenBlocks.getNoteBlockMechanic((Block)block);
    }

    @Nullable
    public static NoteBlockMechanic getNoteBlockMechanic(String itemID) {
        return OraxenBlocks.getNoteBlockMechanic((String)itemID);
    }

    @Nullable
    public static StringBlockMechanic getStringMechanic(BlockData blockData) {
        return OraxenBlocks.getStringMechanic((BlockData)blockData);
    }

    @Nullable
    public static StringBlockMechanic getStringMechanic(Block block) {
        return OraxenBlocks.getStringMechanic((Block)block);
    }

    @Nullable
    public static StringBlockMechanic getStringMechanic(String itemID) {
        return OraxenBlocks.getStringMechanic((String)itemID);
    }

    @Nullable
    public static BlockMechanic getBlockMechanic(Block block) {
        return OraxenBlocks.getBlockMechanic((Block)block);
    }

    public static void loadItems() {
        OraxenItems.loadItems();
    }

    public static String getIdByItem(ItemBuilder item) {
        return OraxenItems.getIdByItem((ItemBuilder)item);
    }

    public static String getIdByItem(ItemStack item) {
        return OraxenItems.getIdByItem((ItemStack)item);
    }

    public static boolean exists(String itemId) {
        return OraxenItems.exists((String)itemId);
    }

    public static boolean exists(ItemStack itemStack) {
        return OraxenItems.exists((ItemStack)itemStack);
    }

    public static Optional<ItemBuilder> getOptionalItemById(String id) {
        return OraxenItems.getOptionalItemById((String)id);
    }

    public static ItemBuilder getItemById(String id) {
        return OraxenItems.getItemById((String)id);
    }

    public static ItemBuilder getBuilderByItem(ItemStack item) {
        return OraxenItems.getBuilderByItem((ItemStack)item);
    }

    public static List<ItemBuilder> getUnexcludedItems() {
        return OraxenItems.getUnexcludedItems();
    }

    public static List<ItemBuilder> getUnexcludedItems(File file) {
        return OraxenItems.getUnexcludedItems((File)file);
    }

    public static List<ItemStack> getItemStacksByName(List<List<String>> lists) {
        return OraxenItems.getItemStacksByName(lists);
    }

    public static boolean hasMechanic(String itemID, String mechanicID) {
        return OraxenItems.hasMechanic((String)itemID, (String)mechanicID);
    }

    public static Map<File, Map<String, ItemBuilder>> getMap() {
        return OraxenItems.getMap();
    }

    public static Map<String, ItemBuilder> getEntriesAsMap() {
        return OraxenItems.getEntriesAsMap();
    }

    public static Set<Map.Entry<String, ItemBuilder>> getEntries() {
        return OraxenItems.getEntries();
    }

    public static Collection<ItemBuilder> getItems() {
        return OraxenItems.getItems();
    }

    public static Set<String> getNames() {
        return OraxenItems.getNames();
    }

    public static String[] nameArray() {
        return OraxenItems.nameArray();
    }

    public static Stream<String> nameStream() {
        return OraxenItems.nameStream();
    }

    public static Stream<ItemBuilder> itemStream() {
        return OraxenItems.itemStream();
    }

    public static Stream<Map.Entry<String, ItemBuilder>> entryStream() {
        return OraxenItems.entryStream();
    }

    public static String[] getItemNames() {
        return OraxenItems.getItemNames();
    }

    public static Set<String> getFurnitureIDs() {
        return OraxenFurniture.getFurnitureIDs();
    }

    public static boolean isFurniture(Block block) {
        return OraxenFurniture.isFurniture((Block)block);
    }

    public static boolean isFurniture(String itemID) {
        return OraxenFurniture.isFurniture((String)itemID);
    }

    public static boolean isFurniture(Entity entity) {
        return OraxenFurniture.isFurniture((Entity)entity);
    }

    public static boolean isBaseEntity(Entity entity) {
        return OraxenFurniture.isBaseEntity((Entity)entity);
    }

    public static boolean remove(Entity baseEntity, @org.eclipse.jdt.annotation.Nullable Player player) {
        return OraxenFurniture.remove((Entity)baseEntity, (Player)player);
    }

    public static boolean remove(Entity baseEntity, @org.eclipse.jdt.annotation.Nullable Player player, @org.eclipse.jdt.annotation.Nullable Drop drop) {
        return OraxenFurniture.remove((Entity)baseEntity, (Player)player, (Drop)drop);
    }

    public static @org.eclipse.jdt.annotation.Nullable FurnitureMechanic getFurnitureMechanic(Block block) {
        return OraxenFurniture.getFurnitureMechanic((Block)block);
    }

    public static FurnitureMechanic getFurnitureMechanic(Entity entity) {
        return OraxenFurniture.getFurnitureMechanic((Entity)entity);
    }

    public static FurnitureMechanic getFurnitureMechanic(String itemID) {
        return OraxenFurniture.getFurnitureMechanic((String)itemID);
    }

    public static void updateFurniture(@NotNull Entity entity) {
        OraxenFurniture.updateFurniture((Entity)entity);
    }
}

