/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.clicklisteners;

import java.util.Objects;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.TabbedPanelBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.listeners.flags.clicklisteners.GeoMobLimitTab;
import world.bentobox.bentobox.managers.IslandWorldManager;
import world.bentobox.bentobox.util.Util;

public class GeoLimitClickListener
implements PanelItem.ClickHandler {
    @Override
    public boolean onClick(Panel panel, User user, ClickType clickType, int slot) {
        World w;
        if (!user.inWorld()) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return true;
        }
        World world = panel.getWorld().orElse(user.getWorld());
        IslandWorldManager iwm = BentoBox.getInstance().getIWM();
        String reqPerm = iwm.getPermissionPrefix(w = Objects.requireNonNull(Util.getWorld(world))) + "admin.settings.GEO_LIMIT_MOBS";
        if (!user.hasPermission(reqPerm)) {
            user.sendMessage("general.errors.no-permission", "[permission]", reqPerm);
            user.getPlayer().playSound(user.getLocation(), Sound.BLOCK_METAL_HIT, 1.0f, 1.0f);
            return true;
        }
        this.openPanel(user, world);
        return true;
    }

    private void openPanel(User user, World world) {
        user.closeInventory();
        new TabbedPanelBuilder().user(user).world(world).tab(1, new GeoMobLimitTab(user, GeoMobLimitTab.EntityLimitTabType.GEO_LIMIT, world)).startingSlot(1).size(54).build().openPanel();
    }
}

