/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.managers;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.hooks.Hook;
import world.bentobox.bentobox.hooks.WorldManagementHook;

public class IslandWorldManager {
    private final BentoBox plugin;
    private final Map<@NonNull World, @NonNull GameModeAddon> gameModes;

    public IslandWorldManager(BentoBox plugin) {
        this.plugin = plugin;
        this.gameModes = new HashMap<World, GameModeAddon>();
    }

    public void registerWorldsToMultiverse(boolean reg) {
        this.gameModes.values().stream().distinct().forEach(gm -> {
            this.registerToWorldManagementPlugins(gm.getOverWorld(), true, reg);
            this.registerSeedWorld(gm.getOverWorld(), reg);
            if (gm.getWorldSettings().isNetherGenerate()) {
                this.registerToWorldManagementPlugins(gm.getNetherWorld(), gm.getWorldSettings().isNetherIslands(), reg);
                this.registerSeedWorld(gm.getNetherWorld(), reg);
            }
            if (gm.getWorldSettings().isEndGenerate()) {
                this.registerToWorldManagementPlugins(gm.getEndWorld(), gm.getWorldSettings().isEndIslands(), reg);
                this.registerSeedWorld(gm.getEndWorld(), reg);
            }
        });
    }

    private void registerSeedWorld(World world, boolean reg) {
        if (world == null) {
            return;
        }
        World seed = Bukkit.getWorld((String)(world.getName() + "/bentobox"));
        if (seed != null) {
            this.registerToWorldManagementPlugins(seed, true, reg);
        }
    }

    private void registerToWorldManagementPlugins(@NonNull World world, boolean islandWorld, boolean reg) {
        if (this.plugin.getHooks() == null) {
            return;
        }
        for (Hook hook : this.plugin.getHooks().getHooks()) {
            if (!(hook instanceof WorldManagementHook)) continue;
            WorldManagementHook worldManagementHook = (WorldManagementHook)((Object)hook);
            if (Bukkit.isPrimaryThread()) {
                this.runTask(worldManagementHook, world, islandWorld, reg);
                continue;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.runTask(worldManagementHook, world, islandWorld, reg));
        }
    }

    private void runTask(WorldManagementHook worldManagementHook, @NonNull World world, boolean islandWorld, boolean reg) {
        if (reg) {
            worldManagementHook.registerWorld(world, islandWorld);
        } else {
            worldManagementHook.unregisterWorld(world);
        }
    }

    public boolean inWorld(@Nullable Location loc) {
        return loc != null && this.inWorld(loc.getWorld());
    }

    public boolean inWorld(@Nullable World world) {
        return world != null && this.gameModes.containsKey(world) && (world.getEnvironment().equals((Object)World.Environment.NORMAL) || this.isIslandNether(world) || this.isIslandEnd(world));
    }

    public @NonNull Set<World> getWorlds() {
        return this.gameModes.keySet();
    }

    public List<World> getOverWorlds() {
        return this.gameModes.keySet().stream().filter(w -> w.getEnvironment().equals((Object)World.Environment.NORMAL)).toList();
    }

    public Map<String, String> getOverWorldNames() {
        return this.gameModes.values().stream().distinct().collect(Collectors.toMap(a -> a.getOverWorld().getName(), a -> a.getWorldSettings().getFriendlyName()));
    }

    public boolean isKnownFriendlyWorldName(String name) {
        return this.gameModes.values().stream().distinct().anyMatch(gm -> gm.getWorldSettings().getFriendlyName().equalsIgnoreCase(name));
    }

    public void addWorld(World world, GameModeAddon gameMode) {
        this.gameModes.put(world, gameMode);
    }

    public void addGameMode(@NonNull GameModeAddon gameMode) {
        WorldSettings settings = gameMode.getWorldSettings();
        World world = gameMode.getOverWorld();
        if (world == null) {
            throw new NullPointerException("Gamemode overworld object is null for " + gameMode.getDescription().getName());
        }
        String friendlyName = settings.getFriendlyName().isEmpty() ? world.getName() : settings.getFriendlyName();
        this.gameModes.put(world, gameMode);
        this.registerToWorldManagementPlugins(world, true, true);
        if (settings.isNetherGenerate() && gameMode.getNetherWorld() != null) {
            this.gameModes.put(gameMode.getNetherWorld(), gameMode);
            if (settings.isNetherIslands()) {
                this.registerToWorldManagementPlugins(gameMode.getNetherWorld(), true, true);
            }
        }
        if (settings.isEndGenerate() && gameMode.getEndWorld() != null) {
            this.gameModes.put(gameMode.getEndWorld(), gameMode);
            if (settings.isEndIslands()) {
                this.registerToWorldManagementPlugins(gameMode.getEndWorld(), true, true);
            }
        }
        this.plugin.getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.PROTECTION)).forEach(f -> settings.getDefaultIslandFlagNames().putIfAbsent(f.getID(), f.getDefaultRank()));
        this.plugin.getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.SETTING)).forEach(f -> settings.getDefaultIslandSettingNames().putIfAbsent(f.getID(), f.getDefaultRank()));
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Difficulty diff = settings.getDifficulty();
            if (diff == null) {
                diff = Difficulty.NORMAL;
                settings.setDifficulty(diff);
            }
            world.setDifficulty(diff);
            if (settings.isNetherGenerate()) {
                this.getNetherWorld(world).setDifficulty(diff);
            }
            if (settings.isEndGenerate()) {
                this.getEndWorld(world).setDifficulty(diff);
            }
            this.plugin.log("Added world " + friendlyName + " (" + String.valueOf(world.getDifficulty()) + ")");
        });
    }

    public @NonNull WorldSettings getWorldSettings(@NonNull World world) {
        return Objects.requireNonNull(this.gameModes.get(world), "Attempt to get WorldSettings for non-game world " + world.getName()).getWorldSettings();
    }

    public @Nullable World getOverWorld(@NonNull String friendlyName) {
        return this.gameModes.values().stream().distinct().filter(gm -> gm.getWorldSettings().getFriendlyName().equalsIgnoreCase(friendlyName)).map(GameModeAddon::getOverWorld).findFirst().orElse(null);
    }

    public int getIslandDistance(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIslandDistance() : 0;
    }

    public int getIslandHeight(@NonNull World world) {
        if (this.gameModes.containsKey(world) && world.getMaxHeight() > 0) {
            return Math.min(world.getMaxHeight() - 1, Math.max(world.getMinHeight(), this.gameModes.get(world).getWorldSettings().getIslandHeight()));
        }
        return 0;
    }

    public int getIslandProtectionRange(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIslandProtectionRange() : 0;
    }

    public int getIslandStartX(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIslandStartX() : 0;
    }

    public int getIslandStartZ(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIslandStartZ() : 0;
    }

    public int getIslandXOffset(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIslandXOffset() : 0;
    }

    public int getIslandZOffset(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIslandZOffset() : 0;
    }

    public int getMaxIslands(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getMaxIslands() : 0;
    }

    public int getNetherSpawnRadius(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getNetherSpawnRadius() : 0;
    }

    public int getSeaHeight(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getSeaHeight() : 0;
    }

    public String getWorldName(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getWorldName().toLowerCase(Locale.ENGLISH) : world.getName();
    }

    public boolean isEndGenerate(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isEndGenerate();
    }

    public boolean isEndIslands(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isEndIslands();
    }

    public boolean isNetherGenerate(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isNetherGenerate();
    }

    public boolean isNetherIslands(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isNetherIslands();
    }

    public boolean isNether(@Nullable World world) {
        return world != null && world.getEnvironment().equals((Object)World.Environment.NETHER) && this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isNetherGenerate();
    }

    public boolean isIslandNether(@Nullable World world) {
        return world != null && world.getEnvironment().equals((Object)World.Environment.NETHER) && this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isNetherGenerate() && this.gameModes.get(world).getWorldSettings().isNetherIslands();
    }

    public boolean isEnd(@Nullable World world) {
        return world != null && world.getEnvironment().equals((Object)World.Environment.THE_END) && this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isEndGenerate();
    }

    public boolean isIslandEnd(@Nullable World world) {
        return world != null && world.getEnvironment().equals((Object)World.Environment.THE_END) && this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isEndGenerate() && this.gameModes.get(world).getWorldSettings().isEndIslands();
    }

    public @Nullable World getNetherWorld(@Nullable World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getNetherWorld() : null;
    }

    public @Nullable World getEndWorld(@Nullable World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getEndWorld() : null;
    }

    public boolean isDragonSpawn(@Nullable World world) {
        return world == null || !this.gameModes.containsKey(world) || this.gameModes.get(world).getWorldSettings().isDragonSpawn();
    }

    public String getFriendlyNames() {
        StringBuilder r = new StringBuilder();
        this.gameModes.values().stream().distinct().forEach(n -> r.append(n.getWorldSettings().getFriendlyName()).append(", "));
        if (!r.isEmpty()) {
            r.setLength(r.length() - 2);
        }
        return r.toString();
    }

    public @Nullable World getIslandWorld(String friendlyWorldName) {
        return this.gameModes.entrySet().stream().filter(e -> ((GameModeAddon)e.getValue()).getWorldSettings().getFriendlyName().equalsIgnoreCase(friendlyWorldName)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public int getMaxTeamSize(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getMaxTeamSize() : 0;
    }

    public int getMaxCoopSize(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getMaxCoopSize() : 0;
    }

    public int getMaxTrustSize(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getMaxTrustSize() : 0;
    }

    public int getMaxHomes(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getMaxHomes() : 0;
    }

    public String getFriendlyName(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getFriendlyName() : world.getName();
    }

    public String getPermissionPrefix(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getPermissionPrefix() + "." : "";
    }

    public List<String> getIvSettings(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getIvSettings() : Collections.emptyList();
    }

    public boolean isWorldFlag(@NonNull World world, @NonNull Flag flag) {
        return flag.isSetForWorld(world);
    }

    public GameMode getDefaultGameMode(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getDefaultGameMode() : GameMode.SURVIVAL;
    }

    public Set<EntityType> getRemoveMobsWhitelist(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getRemoveMobsWhitelist() : Collections.emptySet();
    }

    public boolean isOnJoinResetMoney(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnJoinResetMoney();
    }

    public boolean isOnJoinResetInventory(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnJoinResetInventory();
    }

    public boolean isOnJoinResetEnderChest(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnJoinResetEnderChest();
    }

    public boolean isOnJoinResetHealth(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnJoinResetHealth();
    }

    public boolean isOnJoinResetHunger(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnJoinResetHunger();
    }

    public boolean isOnJoinResetXP(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnJoinResetXP();
    }

    public @NonNull List<String> getOnJoinCommands(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getOnJoinCommands() : Collections.emptyList();
    }

    public boolean isOnLeaveResetMoney(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnLeaveResetMoney();
    }

    public boolean isOnLeaveResetInventory(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnLeaveResetInventory();
    }

    public boolean isOnLeaveResetEnderChest(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnLeaveResetEnderChest();
    }

    public boolean isOnLeaveResetHealth(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnLeaveResetHealth();
    }

    public boolean isOnLeaveResetHunger(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnLeaveResetHunger();
    }

    public boolean isOnLeaveResetXP(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isOnLeaveResetXP();
    }

    public @NonNull List<String> getOnLeaveCommands(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getOnLeaveCommands() : Collections.emptyList();
    }

    public @NonNull List<String> getOnRespawnCommands(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getOnRespawnCommands() : Collections.emptyList();
    }

    public File getDataFolder(@NonNull World world) {
        return this.getAddon(world).map(Addon::getDataFolder).orElseGet(() -> ((BentoBox)this.plugin).getDataFolder());
    }

    public Optional<GameModeAddon> getAddon(@Nullable World world) {
        return world == null ? Optional.empty() : Optional.ofNullable(this.gameModes.get(world));
    }

    public Map<Flag, Integer> getDefaultIslandFlags(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.convertToFlags(this.gameModes.get(world).getWorldSettings().getDefaultIslandFlagNames()) : Collections.emptyMap();
    }

    public List<String> getHiddenFlags(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getHiddenFlags() : Collections.emptyList();
    }

    public Map<Flag, Integer> getDefaultIslandSettings(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.convertToFlags(this.gameModes.get(world).getWorldSettings().getDefaultIslandSettingNames()) : Collections.emptyMap();
    }

    public boolean isUseOwnGenerator(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isUseOwnGenerator();
    }

    public boolean isCheckForBlocks(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isCheckForBlocks();
    }

    public List<String> getVisitorBannedCommands(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getVisitorBannedCommands() : Collections.emptyList();
    }

    public List<String> getFallingBannedCommands(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getFallingBannedCommands() : Collections.emptyList();
    }

    public boolean isWaterNotSafe(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isWaterUnsafe();
    }

    public List<String> getGeoLimitSettings(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getGeoLimitSettings() : Collections.emptyList();
    }

    public List<String> getMobLimitSettings(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getMobLimitSettings() : Collections.emptyList();
    }

    public int getResetLimit(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getResetLimit() : -1;
    }

    public long getResetEpoch(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getResetEpoch() : 0L;
    }

    public void setResetEpoch(@NonNull World world) {
        if (this.gameModes.containsKey(world)) {
            this.gameModes.get(world).getWorldSettings().setResetEpoch(System.currentTimeMillis());
        }
    }

    public boolean isTeamJoinDeathReset(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isTeamJoinDeathReset();
    }

    public boolean isDeathsResetOnNewIsland(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isDeathsResetOnNewIsland();
    }

    public int getDeathsMax(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getDeathsMax() : 0;
    }

    public int getBanLimit(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getBanLimit() : 0;
    }

    public boolean isLeaversLoseReset(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isLeaversLoseReset();
    }

    public boolean isKickedKeepInventory(@NonNull World world) {
        return !this.gameModes.containsKey(world) || this.gameModes.get(world).getWorldSettings().isKickedKeepInventory();
    }

    public boolean isCreateIslandOnFirstLoginEnabled(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isCreateIslandOnFirstLoginEnabled();
    }

    public int getCreateIslandOnFirstLoginDelay(@NonNull World world) {
        return this.gameModes.containsKey(world) ? this.gameModes.get(world).getWorldSettings().getCreateIslandOnFirstLoginDelay() : 0;
    }

    public boolean isCreateIslandOnFirstLoginAbortOnLogout(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isCreateIslandOnFirstLoginAbortOnLogout();
    }

    public boolean isPasteMissingIslands(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isPasteMissingIslands();
    }

    public boolean isTeleportPlayerToIslandUponIslandCreation(@NonNull World world) {
        return this.gameModes.containsKey(world) && this.gameModes.get(world).getWorldSettings().isTeleportPlayerToIslandUponIslandCreation();
    }

    private Map<Flag, Integer> convertToFlags(Map<String, Integer> flagNamesMap) {
        HashMap<Flag, Integer> flagMap = new HashMap<Flag, Integer>();
        flagNamesMap.forEach((key, value) -> this.plugin.getFlagsManager().getFlag((String)key).ifPresent(flag -> flagMap.put((Flag)flag, (Integer)value)));
        return flagMap;
    }
}

