/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.versions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.util.Util;

public class ServerCompatibility {
    private static final ServerCompatibility instance = new ServerCompatibility();
    private Compatibility result;

    public static ServerCompatibility getInstance() {
        return instance;
    }

    private ServerCompatibility() {
    }

    public Compatibility checkCompatibility() {
        if (this.result == null) {
            ServerVersion version = this.getServerVersion();
            if (version == null || version.getCompatibility().equals((Object)Compatibility.INCOMPATIBLE)) {
                this.result = Compatibility.INCOMPATIBLE;
                return this.result;
            }
            ServerSoftware software = this.getServerSoftware();
            if (software.getCompatibility().equals((Object)Compatibility.INCOMPATIBLE)) {
                this.result = Compatibility.INCOMPATIBLE;
                return this.result;
            }
            if (software.getCompatibility().equals((Object)Compatibility.NOT_SUPPORTED) || version.getCompatibility().equals((Object)Compatibility.NOT_SUPPORTED)) {
                this.result = Compatibility.NOT_SUPPORTED;
                return this.result;
            }
            if (software.getCompatibility().equals((Object)Compatibility.SUPPORTED) || version.getCompatibility().equals((Object)Compatibility.SUPPORTED)) {
                this.result = Compatibility.SUPPORTED;
                return this.result;
            }
            this.result = Compatibility.COMPATIBLE;
            return this.result;
        }
        return this.result;
    }

    public @NonNull ServerSoftware getServerSoftware() {
        if (Util.isPaper()) {
            return ServerSoftware.PAPER;
        }
        String[] parts = Bukkit.getServer().getBukkitVersion().split("-");
        if (parts.length < 2) {
            return ServerSoftware.UNKNOWN.setName(Bukkit.getServer().getBukkitVersion().toUpperCase(Locale.ENGLISH));
        }
        String serverSoftware = Bukkit.getServer().getVersion().split("-")[1];
        try {
            return ServerSoftware.valueOf(serverSoftware.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return ServerSoftware.UNKNOWN.setName(serverSoftware.toUpperCase(Locale.ENGLISH));
        }
    }

    public @Nullable ServerVersion getServerVersion() {
        String serverVersion = Bukkit.getServer().getBukkitVersion().split("-")[0].replace(".", "_");
        try {
            return ServerVersion.valueOf("V" + serverVersion.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isVersion(ServerVersion ... versions) {
        return Arrays.asList(versions).contains((Object)this.getServerVersion());
    }

    public boolean isSoftware(ServerSoftware ... softwares) {
        return Arrays.asList(softwares).contains((Object)this.getServerSoftware());
    }

    public static enum Compatibility {
        COMPATIBLE(true),
        SUPPORTED(true),
        NOT_SUPPORTED(true),
        INCOMPATIBLE(false);

        private final boolean canLaunch;

        private Compatibility(boolean canLaunch) {
            this.canLaunch = canLaunch;
        }

        public boolean isCanLaunch() {
            return this.canLaunch;
        }
    }

    public static enum ServerVersion {
        V1_21(Compatibility.INCOMPATIBLE),
        V1_21_1(Compatibility.INCOMPATIBLE),
        V1_21_2(Compatibility.INCOMPATIBLE),
        V1_21_3(Compatibility.NOT_SUPPORTED),
        V1_21_4(Compatibility.NOT_SUPPORTED),
        V1_21_5(Compatibility.COMPATIBLE),
        V1_21_6(Compatibility.COMPATIBLE),
        V1_21_7(Compatibility.COMPATIBLE),
        V1_21_8(Compatibility.COMPATIBLE),
        V1_21_9(Compatibility.NOT_SUPPORTED),
        V1_21_10(Compatibility.COMPATIBLE);

        private final Compatibility compatibility;

        private ServerVersion(Compatibility compatibility) {
            this.compatibility = compatibility;
        }

        public Compatibility getCompatibility() {
            return this.compatibility;
        }

        public @NonNull String toString() {
            return super.toString().substring(1).replace("_", ".");
        }

        public static @NonNull List<ServerVersion> getVersions(Compatibility ... compatibility) {
            LinkedList<ServerVersion> versions = new LinkedList<ServerVersion>();
            for (ServerVersion version : ServerVersion.values()) {
                if (!Arrays.asList(compatibility).contains((Object)version.getCompatibility())) continue;
                versions.add(version);
            }
            return versions;
        }
    }

    public static enum ServerSoftware {
        CRAFTBUKKIT(Compatibility.INCOMPATIBLE),
        BUKKIT(Compatibility.INCOMPATIBLE),
        GLOWSTONE(Compatibility.INCOMPATIBLE),
        SPIGOT(Compatibility.COMPATIBLE),
        PAPER(Compatibility.SUPPORTED),
        PURPUR(Compatibility.SUPPORTED),
        TACOSPIGOT(Compatibility.NOT_SUPPORTED),
        AKARIN(Compatibility.NOT_SUPPORTED),
        UNKNOWN(Compatibility.INCOMPATIBLE);

        private final Compatibility compatibility;
        private String name;

        private ServerSoftware(Compatibility compatibility) {
            this.compatibility = compatibility;
        }

        public String getName() {
            return this.name;
        }

        public ServerSoftware setName(String name) {
            this.name = name;
            return this;
        }

        public Compatibility getCompatibility() {
            return this.compatibility;
        }
    }
}

