/*
 * Decompiled with CFR 0.152.
 */
package com.msg.ensity_functions.worldgen.densityfunction;

import com.mojang.serialization.MapCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public final class FloatingIslands
implements DensityFunction.SimpleFunction {
    public static final KeyDispatchDataCodec<FloatingIslands> CODEC = KeyDispatchDataCodec.of((MapCodec)MapCodec.unit((Object)new FloatingIslands(0L)));
    private static final float ISLAND_THRESHOLD = -0.9f;
    private final SimplexNoise islandNoise;

    public FloatingIslands(long seed) {
        LegacyRandomSource randomSource = new LegacyRandomSource(seed);
        randomSource.consumeCount(17292);
        this.islandNoise = new SimplexNoise((RandomSource)randomSource);
    }

    private static float getHeightValue(SimplexNoise noise, int x, int z) {
        int i = x / 2;
        x %= 2;
        int j = z / 2;
        z %= 2;
        float f = -100.0f;
        for (int m = -12; m <= 12; ++m) {
            for (int n = -12; n <= 12; ++n) {
                long o = i + m;
                long p = j + n;
                if (!(noise.getValue((double)o, (double)p) < (double)-0.9f)) continue;
                float g = (Mth.abs((float)o) * 3439.0f + Mth.abs((float)p) * 147.0f) % 13.0f + 9.0f;
                float h = x - m * 2;
                float q = z - n * 2;
                float r = 100.0f - Mth.sqrt((float)(h * h + q * q)) * g;
                r = Mth.clamp((float)r, (float)-100.0f, (float)80.0f);
                f = Math.max(f, r);
            }
        }
        return f;
    }

    public double compute(DensityFunction.FunctionContext context) {
        return ((double)FloatingIslands.getHeightValue(this.islandNoise, context.blockX() / 8, context.blockZ() / 8) - 8.0) / 128.0;
    }

    public double minValue() {
        return -0.84375;
    }

    public double maxValue() {
        return 0.5625;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

