/*
 * Decompiled with CFR 0.152.
 */
package com.msg.ensity_functions.worldgen.biome_source;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;

public class NoMainBiomeSource
extends BiomeSource {
    public static final MapCodec<NoMainBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveElement((ResourceKey)Biomes.END_HIGHLANDS), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.END_MIDLANDS), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.SMALL_END_ISLANDS), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.END_BARRENS)).apply((Applicative)instance, instance.stable(NoMainBiomeSource::new)));
    private final Holder<Biome> highlands;
    private final Holder<Biome> midlands;
    private final Holder<Biome> smallIslands;
    private final Holder<Biome> barrens;

    public static NoMainBiomeSource create(HolderGetter<Biome> biomeGetter) {
        return new NoMainBiomeSource((Holder<Biome>)biomeGetter.getOrThrow(Biomes.END_HIGHLANDS), (Holder<Biome>)biomeGetter.getOrThrow(Biomes.END_MIDLANDS), (Holder<Biome>)biomeGetter.getOrThrow(Biomes.SMALL_END_ISLANDS), (Holder<Biome>)biomeGetter.getOrThrow(Biomes.END_BARRENS));
    }

    private NoMainBiomeSource(Holder<Biome> highlands, Holder<Biome> midlands, Holder<Biome> smallIslands, Holder<Biome> barrens) {
        this.highlands = highlands;
        this.midlands = midlands;
        this.smallIslands = smallIslands;
        this.barrens = barrens;
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return Stream.of(this.highlands, this.midlands, this.smallIslands, this.barrens);
    }

    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler noise) {
        double d = noise.erosion().compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext((SectionPos.blockToSectionCoord((int)QuartPos.toBlock((int)x)) * 2 + 1) * 8, QuartPos.toBlock((int)y), (SectionPos.blockToSectionCoord((int)QuartPos.toBlock((int)z)) * 2 + 1) * 8));
        if (d > 0.25) {
            return this.highlands;
        }
        if (d >= -0.0625) {
            return this.midlands;
        }
        return d < -0.21875 ? this.smallIslands : this.barrens;
    }
}

