/*
 * Decompiled with CFR 0.152.
 */
package com.msg.ensity_functions.worldgen.densityfunction;

import com.mojang.serialization.MapCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public final class LonelyIsland
implements DensityFunction.SimpleFunction {
    public static final KeyDispatchDataCodec<LonelyIsland> CODEC = KeyDispatchDataCodec.of((MapCodec)MapCodec.unit((Object)new LonelyIsland(0L)));
    private final SimplexNoise islandNoise;

    public LonelyIsland(long seed) {
        LegacyRandomSource randomSource = new LegacyRandomSource(seed);
        randomSource.consumeCount(17292);
        this.islandNoise = new SimplexNoise((RandomSource)randomSource);
    }

    private static float getHeightValue(SimplexNoise noise, int x, int z) {
        return Mth.clamp((float)(100.0f - Mth.sqrt((float)(x * x + z * z)) * 8.0f), (float)-100.0f, (float)80.0f);
    }

    public double compute(DensityFunction.FunctionContext context) {
        return ((double)LonelyIsland.getHeightValue(this.islandNoise, context.blockX() / 8, context.blockZ() / 8) - 8.0) / 128.0;
    }

    public double minValue() {
        return -0.84375;
    }

    public double maxValue() {
        return 0.5625;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

