/*
 * Decompiled with CFR 0.152.
 */
package dev.ebo2022.pmtemperature.core.mixin;

import com.momosoftworks.coldsweat.util.world.WorldHelper;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.WeatherHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorldHelper.class})
public class WorldHelperMixin {
    @Inject(method={"isRainingAt"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isRainingAt(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ResourceKey dimension = level.dimension();
        if (ServerConfig.validDimensions.contains(dimension)) {
            WeatherHandler handler = (WeatherHandler)GameBusEvents.MANAGERS.get(dimension);
            Vec3 vec3 = new Vec3((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ());
            ThermodynamicEngine.Precipitation type = ThermodynamicEngine.getPrecipitationType((WeatherHandler)handler, (Vec3)vec3, (Level)level, (int)0);
            cir.setReturnValue((Object)((double)handler.getPrecipitation(vec3) > 0.0 && type == ThermodynamicEngine.Precipitation.RAIN && WorldHelper.canSeeSky((LevelAccessor)level, (BlockPos)pos, (int)level.getMaxBuildHeight()) ? 1 : 0));
        }
    }
}

