/*
 * Decompiled with CFR 0.152.
 */
package dev.ebo2022.pmtemperature.core;

import com.mojang.logging.LogUtils;
import com.momosoftworks.coldsweat.api.event.core.init.DefaultTempModifiersEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.CaveBiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.compat.SereneSeasonsTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import dev.ebo2022.pmtemperature.common.cold_sweat.temperature.modifier.WrappedCaveBiomeTempModifier;
import dev.ebo2022.pmtemperature.common.cold_sweat.temperature.modifier.WrappedClimateTempModifier;
import dev.ebo2022.pmtemperature.common.cold_sweat.temperature.modifier.WrappedElevationTempModifier;
import dev.ebo2022.pmtemperature.core.PMTemperatureConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="pmtemperature")
public class PMTemperature {
    public static final String MOD_ID = "pmtemperature";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean COLD_SWEAT_LOADED = ModList.get().isLoaded("cold_sweat");

    public PMTemperature(IEventBus modEventBus, ModContainer modContainer, Dist dist) {
        modEventBus.register(PMTemperatureConfig.class);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)PMTemperatureConfig.SPEC);
        if (dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        if (COLD_SWEAT_LOADED) {
            NeoForge.EVENT_BUS.register(new Object(this){

                @SubscribeEvent
                public void registerTempModifiers(TempModifierRegisterEvent event) {
                    event.register(ResourceLocation.fromNamespaceAndPath((String)PMTemperature.MOD_ID, (String)"wrapped_climate"), WrappedClimateTempModifier::new);
                    event.register(ResourceLocation.fromNamespaceAndPath((String)PMTemperature.MOD_ID, (String)"wrapped_elevation"), WrappedElevationTempModifier::new);
                    event.register(ResourceLocation.fromNamespaceAndPath((String)PMTemperature.MOD_ID, (String)"wrapped_cave_biome"), WrappedCaveBiomeTempModifier::new);
                }

                @SubscribeEvent
                public void addDefaultTempModifiers(DefaultTempModifiersEvent event) {
                    event.getModifiers(Temperature.Trait.WORLD).removeIf(modifier -> modifier instanceof BiomeTempModifier || modifier instanceof ElevationTempModifier || modifier instanceof CaveBiomeTempModifier || modifier instanceof SereneSeasonsTempModifier);
                    event.addModifier(Temperature.Trait.WORLD, (TempModifier)new WrappedClimateTempModifier());
                    event.addModifier(Temperature.Trait.WORLD, (TempModifier)new WrappedElevationTempModifier());
                    event.addModifier(Temperature.Trait.WORLD, (TempModifier)new WrappedCaveBiomeTempModifier());
                }
            });
        }
    }

    public static double getApparentTemperature(float airTemp, float dewPoint, Vec3 wind) {
        if (airTemp > 19.0f) {
            return (double)airTemp + 0.5555 * (6.11 * Math.exp(5417.753 * (0.0036609921 - 1.0 / (273.15 + (double)dewPoint))) - 10.0);
        }
        if (airTemp < 0.0f) {
            return 13.12 + 0.6215 * (double)airTemp - 11.37 * Math.pow(wind.length(), 0.16);
        }
        return airTemp;
    }
}

