/*
 * Decompiled with CFR 0.152.
 */
package dev.ebo2022.pmtemperature.core.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.ebo2022.pmtemperature.core.PMTemperature;
import dev.ebo2022.pmtemperature.core.PMTemperatureConfig;
import dev.ebo2022.pmtemperature.core.util.PMUtil;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WindEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;
import toughasnails.temperature.TemperatureHelperImpl;

@Mixin(value={TemperatureHelperImpl.class})
public class TemperatureHelperImplMixin {
    @Inject(method={"getBiomeTemperatureLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getBiomeTemperatureLevel(Level level, BlockPos pos, CallbackInfoReturnable<TemperatureLevel> cir) {
        ResourceKey dimension = level.dimension();
        if (ServerConfig.validDimensions.contains(dimension)) {
            ThermodynamicEngine.AtmosphericDataPoint data = ThermodynamicEngine.samplePoint((WeatherHandler)((WeatherHandler)GameBusEvents.MANAGERS.get(dimension)), (Vec3)pos.getCenter(), (Level)level, null, (int)0);
            double temperature = PMTemperatureConfig.useApparentTemperature ? PMTemperature.getApparentTemperature(data.temperature(), data.dewpoint(), WindEngine.getWind((BlockPos)pos, (Level)level)) : (double)data.temperature();
            if ((temperature /= 25.0) < 0.15) {
                cir.setReturnValue((Object)TemperatureLevel.ICY);
            }
            if (temperature >= (double)0.15f && temperature < (double)0.45f) {
                cir.setReturnValue((Object)TemperatureLevel.COLD);
            }
            if (temperature >= (double)0.45f && temperature < (double)0.85f) {
                cir.setReturnValue((Object)TemperatureLevel.NEUTRAL);
            }
            if (temperature >= (double)0.85f && temperature < 1.0) {
                cir.setReturnValue((Object)TemperatureLevel.WARM);
            }
            if (temperature >= 1.0) {
                cir.setReturnValue((Object)TemperatureLevel.HOT);
            }
        }
    }

    @Inject(method={"nightModifier"}, at={@At(value="HEAD")}, cancellable=true)
    private static void nightModifier(Level level, BlockPos pos, TemperatureLevel current, CallbackInfoReturnable<TemperatureLevel> cir) {
        if (ServerConfig.validDimensions.contains(level.dimension())) {
            cir.setReturnValue((Object)current);
        }
    }

    @Inject(method={"altitudeModifier"}, at={@At(value="HEAD")}, cancellable=true)
    private static void altitudeModifier(Level level, BlockPos pos, TemperatureLevel current, CallbackInfoReturnable<TemperatureLevel> cir) {
        if (ServerConfig.validDimensions.contains(level.dimension())) {
            cir.setReturnValue((Object)current);
        }
    }

    @Inject(method={"rainModifier"}, at={@At(value="HEAD")}, cancellable=true)
    private static void rainModifier(Level level, BlockPos pos, TemperatureLevel current, CallbackInfoReturnable<TemperatureLevel> cir) {
        if (ServerConfig.validDimensions.contains(level.dimension())) {
            Vec3 overheadPos;
            WeatherHandler weatherHandler = PMUtil.getWeatherHandler(level);
            double precip = weatherHandler.getPrecipitation(overheadPos = PMUtil.overheadPos(pos));
            if (precip >= (double)0.2f && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
                ThermodynamicEngine.Precipitation type = ThermodynamicEngine.getPrecipitationType((WeatherHandler)weatherHandler, (Vec3)overheadPos, (Level)level, (int)0);
                if (type == ThermodynamicEngine.Precipitation.RAIN || type == ThermodynamicEngine.Precipitation.FREEZING_RAIN || type == ThermodynamicEngine.Precipitation.HAIL) {
                    cir.setReturnValue((Object)current.increment(ModConfig.temperature.wetTemperatureChange));
                }
                if (type == ThermodynamicEngine.Precipitation.SNOW || type == ThermodynamicEngine.Precipitation.SLEET || type == ThermodynamicEngine.Precipitation.WINTRY_MIX) {
                    cir.setReturnValue((Object)current.increment(ModConfig.temperature.snowTemperatureChange));
                } else {
                    cir.setReturnValue((Object)current);
                }
            } else {
                cir.setReturnValue((Object)current);
            }
        }
    }

    @WrapOperation(method={"immersionModifier"}, at={@At(value="INVOKE", target="Ltoughasnails/temperature/TemperatureHelperImpl;isExposedToRain(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z")})
    private static boolean immersionModifier(Level level, BlockPos pos, Operation<Boolean> original) {
        ResourceKey dimension = level.dimension();
        if (ServerConfig.validDimensions.contains(dimension)) {
            return level.isRainingAt(pos) && pos.getY() >= level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).below().getY();
        }
        return (Boolean)original.call(new Object[]{level, pos});
    }
}

