/*
 * Decompiled with CFR 0.152.
 */
package com.madu59.banner_hats;

import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BannerHats
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("BannerHats enabled!");
    }

    public void onDisable() {
        this.getLogger().info("BannerHats disabled!");
    }

    @EventHandler
    public void onPickUp(EntityPickupItemEvent event) {
        this.makeBannerEquippable(event.getItem().getItemStack());
    }

    @EventHandler
    public void onPlayerInteraction(PlayerInteractEvent event) {
        this.makeBannerEquippable(event.getItem());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack stack;
        if (event.getWhoClicked().getGameMode() != GameMode.CREATIVE && (event.getCursor() == null || event.getCursor().getType() == Material.AIR) && (stack = this.makeBannerEquippable(event.getCurrentItem())) != null) {
            event.getWhoClicked().setItemOnCursor(stack);
            event.setCurrentItem(null);
            event.setCancelled(true);
        }
        if (event.getWhoClicked().getGameMode() != GameMode.CREATIVE && this.isBanner(event.getCurrentItem().getType()) && (stack = this.makeBannerEquippable(event.getCurrentItem())) != null) {
            event.setCurrentItem(stack);
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        ItemStack result = this.makeBannerEquippable(event.getInventory().getResult());
        if (result != null) {
            event.getInventory().setResult(result);
        }
    }

    public ItemStack makeBannerEquippable(ItemStack item) {
        EquippableComponent equippable;
        ItemMeta meta;
        if (item != null && this.isBanner(item.getType()) && (meta = item.getItemMeta()) != null && (equippable = meta.getEquippable()) != null) {
            equippable.setSlot(EquipmentSlot.HEAD);
            equippable.setEquipSound(Sound.ITEM_ARMOR_EQUIP_GENERIC);
            equippable.setDamageOnHurt(false);
            equippable.setSwappable(true);
            equippable.setDispensable(false);
            meta.setEquippable(equippable);
            item.setItemMeta(meta);
            return item;
        }
        return null;
    }

    private boolean isBanner(Material type) {
        return type.name().endsWith("_BANNER");
    }
}

