/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigerx6.randomizer;

import io.github.tigerx6.randomizer.commands.ChallengeCommand;
import io.github.tigerx6.randomizer.listeners.BlockBreakListener;
import io.github.tigerx6.randomizer.listeners.MobDeathListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lio/github/tigerx6/randomizer/Randomizer;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "onEnable", "", "onDisable", "mobDeathListener", "Lio/github/tigerx6/randomizer/listeners/MobDeathListener;", "getMobDeathListener", "()Lio/github/tigerx6/randomizer/listeners/MobDeathListener;", "blockBreakListener", "Lio/github/tigerx6/randomizer/listeners/BlockBreakListener;", "getBlockBreakListener", "()Lio/github/tigerx6/randomizer/listeners/BlockBreakListener;", "challengeCommand", "Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "getChallengeCommand", "()Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "setChallengeCommand", "(Lio/github/tigerx6/randomizer/commands/ChallengeCommand;)V", "registerEvents", "registerCommands", "Randomizer"})
public final class Randomizer
extends JavaPlugin {
    @NotNull
    private final MobDeathListener mobDeathListener = new MobDeathListener(this);
    @NotNull
    private final BlockBreakListener blockBreakListener = new BlockBreakListener(this);
    @NotNull
    private ChallengeCommand challengeCommand = new ChallengeCommand(this);

    public void onEnable() {
        this.getLogger().info("Randomizer has loaded!");
        this.registerEvents();
        this.registerCommands();
        this.saveDefaultConfig();
        this.getLogger().info("Registered listeners, commands, config");
    }

    public void onDisable() {
        this.getLogger().info("Randomizer has unloaded!");
    }

    @NotNull
    public final MobDeathListener getMobDeathListener() {
        return this.mobDeathListener;
    }

    @NotNull
    public final BlockBreakListener getBlockBreakListener() {
        return this.blockBreakListener;
    }

    @NotNull
    public final ChallengeCommand getChallengeCommand() {
        return this.challengeCommand;
    }

    public final void setChallengeCommand(@NotNull ChallengeCommand challengeCommand) {
        Intrinsics.checkNotNullParameter(challengeCommand, "<set-?>");
        this.challengeCommand = challengeCommand;
    }

    private final void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this.blockBreakListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.mobDeathListener, (Plugin)this);
    }

    private final void registerCommands() {
        block0: {
            this.mobDeathListener.setChallengeCommand(this.challengeCommand);
            this.blockBreakListener.setChallengeCommand(this.challengeCommand);
            PluginCommand pluginCommand = this.getCommand("randomizer");
            if (pluginCommand == null) break block0;
            pluginCommand.setExecutor((CommandExecutor)this.challengeCommand);
        }
    }
}

