/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigerx6.randomizer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/tigerx6/randomizer/database/Database;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "connection", "Ljava/sql/Connection;", "statement", "Ljava/sql/Statement;", "closeConnection", "", "Randomizer"})
public final class Database {
    @NotNull
    private final Connection connection;
    @NotNull
    private final Statement statement;

    public Database(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + path);
        Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
        this.connection = connection;
        Statement statement = this.connection.createStatement();
        Intrinsics.checkNotNullExpressionValue(statement, "createStatement(...)");
        this.statement = statement;
        this.statement.execute("\n            CREATE TABLE IF NOT EXISTS pairs (\n                block TEXT PRIMARY KEY,\n                item TEXT NOT NULL)    \n        ");
        this.statement.close();
    }

    public final void closeConnection() {
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
    }
}

