/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigerx6.randomizer.listeners;

import io.github.tigerx6.randomizer.Randomizer;
import io.github.tigerx6.randomizer.commands.ChallengeCommand;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/tigerx6/randomizer/listeners/BlockBreakListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lio/github/tigerx6/randomizer/Randomizer;", "<init>", "(Lio/github/tigerx6/randomizer/Randomizer;)V", "challengeCommand", "Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "getChallengeCommand", "()Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "setChallengeCommand", "(Lio/github/tigerx6/randomizer/commands/ChallengeCommand;)V", "randomItemMap", "", "Lorg/bukkit/Material;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "shuffle", "", "onBlockBreak", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "Randomizer"})
public final class BlockBreakListener
implements Listener {
    @NotNull
    private ChallengeCommand challengeCommand;
    @NotNull
    private final Map<Material, Material> randomItemMap;
    @NotNull
    private final FileConfiguration config;

    public BlockBreakListener(@NotNull Randomizer plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.challengeCommand = plugin.getChallengeCommand();
        this.randomItemMap = new LinkedHashMap();
        FileConfiguration fileConfiguration = plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
    }

    @NotNull
    public final ChallengeCommand getChallengeCommand() {
        return this.challengeCommand;
    }

    public final void setChallengeCommand(@NotNull ChallengeCommand challengeCommand) {
        Intrinsics.checkNotNullParameter(challengeCommand, "<set-?>");
        this.challengeCommand = challengeCommand;
    }

    public final void shuffle() {
        this.randomItemMap.clear();
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Intrinsics.areEqual(this.challengeCommand.getChallengeStatus(), "start")) {
            if (!this.challengeCommand.getRandomizerPlayers().contains(event.getPlayer().getName()) && this.config.getBoolean("use_player_list")) {
                return;
            }
            if (this.config.getBoolean("block_drops.randomize_block_drops")) {
                event.setDropItems(false);
                Material material = this.randomItemMap.get(event.getBlock().getType());
                if (material == null) {
                    Material material2;
                    do {
                        material2 = material = (Material)EntriesMappings.entries$0.get(Random.Default.nextInt(0, EntriesMappings.entries$0.size()));
                        Intrinsics.checkNotNull(material2);
                    } while (!material2.isItem());
                    if (this.config.getBoolean("save-random-pairs")) {
                        this.randomItemMap.put(event.getBlock().getType(), material);
                    }
                }
                ItemStack itemStack = new ItemStack(material, Random.Default.nextInt(this.config.getInt("block_drops.min_block_drops"), this.config.getInt("block_drops.max_block_drops")));
                event.getPlayer().getWorld().dropItemNaturally(event.getBlock().getLocation(), itemStack);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Material> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Material.values()));
        }
    }
}

