/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigerx6.randomizer.listeners;

import io.github.tigerx6.randomizer.Randomizer;
import io.github.tigerx6.randomizer.commands.ChallengeCommand;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/tigerx6/randomizer/listeners/MobDeathListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lio/github/tigerx6/randomizer/Randomizer;", "<init>", "(Lio/github/tigerx6/randomizer/Randomizer;)V", "challengeCommand", "Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "getChallengeCommand", "()Lio/github/tigerx6/randomizer/commands/ChallengeCommand;", "setChallengeCommand", "(Lio/github/tigerx6/randomizer/commands/ChallengeCommand;)V", "randomItemMap", "", "Lorg/bukkit/Material;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "shuffle", "", "onEntityDeath", "event", "Lorg/bukkit/event/entity/EntityDeathEvent;", "Randomizer"})
public final class MobDeathListener
implements Listener {
    @NotNull
    private ChallengeCommand challengeCommand;
    @NotNull
    private final Map<Material, Material> randomItemMap;
    @NotNull
    private final FileConfiguration config;

    public MobDeathListener(@NotNull Randomizer plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.challengeCommand = plugin.getChallengeCommand();
        this.randomItemMap = new LinkedHashMap();
        FileConfiguration fileConfiguration = plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
    }

    @NotNull
    public final ChallengeCommand getChallengeCommand() {
        return this.challengeCommand;
    }

    public final void setChallengeCommand(@NotNull ChallengeCommand challengeCommand) {
        Intrinsics.checkNotNullParameter(challengeCommand, "<set-?>");
        this.challengeCommand = challengeCommand;
    }

    public final void shuffle() {
        this.randomItemMap.clear();
    }

    @EventHandler
    public final void onEntityDeath(@NotNull EntityDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Intrinsics.areEqual(this.challengeCommand.getChallengeStatus(), "start")) {
            Player player = event.getEntity().getKiller();
            if (!CollectionsKt.contains((Iterable)this.challengeCommand.getRandomizerPlayers(), player != null ? player.getName() : null) && this.config.getBoolean("use_player_list")) {
                return;
            }
            if (event.getEntity() instanceof Mob) {
                if (this.config.getBoolean("mob_drops.randomize_mob_drops")) {
                    event.getDrops().replaceAll(arg_0 -> MobDeathListener.onEntityDeath$lambda$0(this, arg_0));
                }
                if (this.config.getBoolean("mob_drops.randomize_mob_xp_drops")) {
                    event.setDroppedExp(Random.Default.nextInt(this.config.getInt("mob_drops.min_mob_xp"), this.config.getInt("mob_drops.max_mob_xp")));
                }
            }
        }
    }

    private static final ItemStack onEntityDeath$lambda$0(MobDeathListener this$0, ItemStack it) {
        Material material = this$0.randomItemMap.get(it.getType());
        if (material == null) {
            Material material2;
            do {
                material2 = material = (Material)EntriesMappings.entries$0.get(Random.Default.nextInt(0, EntriesMappings.entries$0.size()));
                Intrinsics.checkNotNull(material2);
            } while (!material2.isItem());
            if (this$0.config.getBoolean("save-random-pairs")) {
                this$0.randomItemMap.put(it.getType(), material);
            }
        }
        return new ItemStack(material, Random.Default.nextInt(this$0.config.getInt("mob_drops.min_mob_drops"), this$0.config.getInt("mob_drops.max_mob_drops")));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Material> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Material.values()));
        }
    }
}

