/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.api;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum ChestType implements IStringSerializable
{
    SINGLE,
    LEFT,
    RIGHT,
    UNDEFINED;

    @Nonnull
    public static final PropertyEnum<ChestType> TYPE;

    @Nonnull
    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public int index() {
        return this.ordinal();
    }

    @Nonnull
    public static ChestType fromIndex(int index) {
        return ChestType.fromOrdinal(index);
    }

    @Nonnull
    public static ChestType fromOrdinal(int ordinal) {
        return ChestType.values()[ordinal % ChestType.values().length];
    }

    @Nonnull
    public static ChestType get(@Nonnull IBlockState state) {
        return (ChestType)((Object)state.func_177229_b(TYPE));
    }

    public boolean hasOpposite() {
        return this == LEFT || this == RIGHT;
    }

    @Nonnull
    public ChestType getOpposite() {
        switch (this) {
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
        }
        throw new UnsupportedOperationException("Chest type does not have an \"opposite\" component: " + this.func_176610_l());
    }

    public boolean hasSideAttached() {
        return this == LEFT || this == RIGHT;
    }

    @Nonnull
    public EnumFacing getSideAttached(@Nonnull EnumFacing chestFacing) {
        switch (this) {
            case LEFT: {
                return chestFacing.func_176746_e();
            }
            case RIGHT: {
                return chestFacing.func_176735_f();
            }
        }
        throw new UnsupportedOperationException("Chest type does not have an attached side: " + this.func_176610_l());
    }

    @Nonnull
    public EnumFacing getSideAttached(@Nonnull IBlockState state) {
        return this.getSideAttached((EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a));
    }

    @Nonnull
    public static EnumFacing getDirectionToAttached(@Nonnull IBlockState state) {
        return ChestType.get(state).getSideAttached(state);
    }

    @Nonnull
    public static EnumFacing[] getDirectionsToAttached(@Nonnull IBlockState state) {
        EnumFacing[] enumFacingArray;
        ChestType type = ChestType.get(state);
        if (type.hasSideAttached()) {
            EnumFacing[] enumFacingArray2 = new EnumFacing[1];
            enumFacingArray = enumFacingArray2;
            enumFacingArray2[0] = type.getSideAttached(state);
        } else {
            enumFacingArray = new EnumFacing[]{};
        }
        return enumFacingArray;
    }

    @Deprecated
    @Nonnull
    public EnumFacing rotate(@Nonnull EnumFacing chestFacing) {
        return this.getSideAttached(chestFacing);
    }

    static {
        TYPE = PropertyEnum.func_177707_a((String)"type", ChestType.class, (Collection)ImmutableList.of((Object)((Object)UNDEFINED), (Object)((Object)SINGLE), (Object)((Object)LEFT), (Object)((Object)RIGHT)));
    }
}

