/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.asm.transformers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@FunctionalInterface
public interface IASMClassTransformer
extends IClassTransformer,
Opcodes {
    public static final boolean DEOBFUSCATED = FMLLaunchHandler.isDeobfuscatedEnvironment();

    public void transform(@Nonnull ClassNode var1);

    @Nonnull
    default public String getHookClass() {
        return this.getClass().getName().replace('.', '/') + "$Hooks";
    }

    @Nonnull
    default public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, 4);
        this.transform(classNode);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    default public void lockHorizontals(@Nonnull ClassNode classNode, @Nonnull String deobfName, @Nonnull String obfName, @Nonnull Consumer<InsnList> inject) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(DEOBFUSCATED ? deobfName : obfName)) continue;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() != 178 || !((FieldInsnNode)insn).name.equals(DEOBFUSCATED ? "HORIZONTALS" : "field_176754_o")) continue;
                InsnList list = new InsnList();
                inject.accept(list);
                method.instructions.insertBefore(insn, list);
                method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/friendly_chests/api/ChestType", "getDirectionsToAttached", "(Lnet/minecraft/block/state/IBlockState;)[Lnet/minecraft/util/EnumFacing;", false));
                method.instructions.remove(insn);
                return;
            }
        }
    }

    default public void overwriteMethod(@Nonnull ClassNode classNode, @Nonnull String deobfName, @Nonnull String obfName, @Nonnull String desc, @Nonnull Consumer<GeneratorAdapter> generator) {
        MethodNode method = new MethodNode(1, DEOBFUSCATED ? deobfName : obfName, desc, null, null);
        classNode.methods.removeIf(candidate -> {
            if (candidate.name.equals(method.name) && candidate.desc.equals(method.desc)) {
                method.access = candidate.access;
                return true;
            }
            return false;
        });
        final LinkedList generatedHookDescriptor = Lists.newLinkedList();
        final ArrayList mappedArguments = (method.access & 8) != 0 ? Lists.newArrayList() : Lists.newArrayList((Object[])new Type[]{Type.getObjectType((String)classNode.name)});
        for (Type type : Type.getArgumentTypes((String)desc)) {
            for (int i = type.getSize(); i > 0; --i) {
                mappedArguments.add(type);
            }
        }
        GeneratorAdapter adapter = new GeneratorAdapter(new MethodVisitor(327680, (MethodVisitor)method){

            public void visitVarInsn(int opcode, int var) {
                generatedHookDescriptor.add(mappedArguments.get(var));
                super.visitVarInsn(opcode, var);
            }

            public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
                Type returnType;
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                int size = Type.getArgumentTypes((String)desc).length;
                for (int i = 0; i < size; ++i) {
                    generatedHookDescriptor.removeLast();
                }
                if (opcode != 184) {
                    generatedHookDescriptor.removeLast();
                }
                if ((returnType = Type.getReturnType((String)desc)) != Type.VOID_TYPE) {
                    generatedHookDescriptor.add(returnType);
                }
            }
        }, method.access, method.name, method.desc);
        generator.accept(adapter);
        adapter.invokeStatic(Type.getObjectType((String)this.getHookClass()), new Method(deobfName, Type.getReturnType((String)desc), generatedHookDescriptor.toArray(new Type[0])));
        adapter.returnValue();
        classNode.methods.add(method);
    }
}

