/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.asm.transformers.modded;

import com.teammetallurgy.atum.blocks.base.BlockChestBase;
import com.teammetallurgy.atum.blocks.base.tileentity.TileEntityChestBase;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.BlockChestSpawner;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.BlockLimestoneChest;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.BlockSarcophagus;
import git.jbredwards.friendly_chests.api.ChestType;
import git.jbredwards.friendly_chests.mod.asm.transformers.IASMClassTransformer;
import git.jbredwards.friendly_chests.mod.asm.transformers.vanilla.TransformerBlockChest;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerAtumBlockBase
implements IASMClassTransformer {
    @Override
    public void transform(@Nonnull ClassNode classNode) {
        classNode.methods.removeIf(method -> method.name.equals(DEOBFUSCATED ? "getBoundingBox" : "func_185496_a") || method.name.equals(DEOBFUSCATED ? "getContainer" : "func_189418_a") || method.name.equals(DEOBFUSCATED ? "onBlockAdded" : "func_176213_c"));
        this.lockHorizontals(classNode, "harvestBlock", "func_180657_a", instructions -> instructions.add((AbstractInsnNode)new VarInsnNode(25, 4)));
        this.overwriteMethod(classNode, "canPlaceBlockAt", "func_176196_c", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
        });
        this.overwriteMethod(classNode, "chestMatches", "chestMatches", "(Lnet/minecraft/world/World;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;)Z", adapter -> {
            adapter.loadThis();
            adapter.loadArg(1);
            adapter.loadArg(3);
        });
        this.overwriteMethod(classNode, "getStateForPlacement", "func_180642_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;FFFILnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/block/state/IBlockState;", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
            adapter.loadArg(7);
        });
        this.overwriteMethod(classNode, "onBlockPlacedBy", "func_180633_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", adapter -> {
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
            adapter.loadArg(4);
        });
    }

    public static final class Hooks {
        public static boolean canPlaceBlockAt(@Nonnull BlockChestBase block, @Nonnull World world, @Nonnull BlockPos pos) {
            if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                return false;
            }
            if (!(block instanceof BlockSarcophagus)) {
                return true;
            }
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                if (!Hooks.canPlaceSarcophagusAt(world, pos.func_177972_a(direction))) continue;
                return true;
            }
            return false;
        }

        private static boolean canPlaceSarcophagusAt(@Nonnull World world, @Nonnull BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_72855_b(new AxisAlignedBB(pos));
        }

        public static boolean chestMatches(@Nonnull BlockChestBase block, @Nonnull IBlockState state, @Nonnull IBlockState other) {
            if (!Block.func_149680_a((Block)state.func_177230_c(), (Block)other.func_177230_c())) {
                return false;
            }
            if (block instanceof BlockChestSpawner) {
                return false;
            }
            if (block instanceof BlockLimestoneChest || block instanceof BlockSarcophagus) {
                return true;
            }
            throw new UnsupportedOperationException("Unknown Atum block found, report this to Friendly Chests! " + block);
        }

        @Nonnull
        public static IBlockState getStateForPlacement(@Nonnull BlockChestBase block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EntityLivingBase placer) {
            if (block instanceof BlockLimestoneChest || block instanceof BlockChestSpawner) {
                return TransformerBlockChest.Hooks.getStateForPlacement((BlockChest)block, world, pos, side, placer);
            }
            if (block instanceof BlockSarcophagus) {
                EnumFacing facing = placer.func_174811_aO().func_176734_d();
                if (Hooks.canPlaceSarcophagusAt(world, pos.func_177972_a(facing.func_176735_f()))) {
                    return block.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing).func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.RIGHT));
                }
                if (Hooks.canPlaceSarcophagusAt(world, pos.func_177972_a(facing.func_176746_e()))) {
                    return block.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing).func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.LEFT));
                }
                if (Hooks.canPlaceSarcophagusAt(world, pos.func_177972_a(facing.func_176734_d()))) {
                    return block.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing.func_176746_e()).func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.LEFT));
                }
                return block.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing.func_176746_e()).func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.RIGHT));
            }
            throw new UnsupportedOperationException("Unknown Atum block found, report this to Friendly Chests! " + block);
        }

        public static void onBlockPlacedBy(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull ItemStack stack) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityChestBase) {
                TileEntityChestBase tileChest = (TileEntityChestBase)tile;
                if (stack.func_82837_s()) {
                    tileChest.func_190575_a(stack.func_82833_r());
                }
                if (!tileChest.canBeSingle && tileChest.canBeDouble) {
                    ChestType type = ChestType.get(state);
                    world.func_180501_a(pos.func_177972_a(type.getSideAttached(state)), state.func_177226_a(ChestType.TYPE, (Comparable)((Object)type.getOpposite())), 11);
                }
            }
        }
    }
}

