/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.asm.transformers.vanilla;

import git.jbredwards.friendly_chests.api.BlockSource;
import git.jbredwards.friendly_chests.api.ChestType;
import git.jbredwards.friendly_chests.api.IChestMatchable;
import git.jbredwards.friendly_chests.mod.asm.transformers.IASMClassTransformer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.tree.ClassNode;

public final class TransformerBlockChest
implements IASMClassTransformer {
    @Override
    public void transform(@Nonnull ClassNode classNode) {
        classNode.interfaces.add("git/jbredwards/friendly_chests/api/IChestMatchable");
        classNode.methods.removeIf(method -> method.name.equals(DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.overwriteMethod(classNode, "checkForSurroundingChests", "func_176455_e", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)Lnet/minecraft/block/state/IBlockState;", adapter -> {
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
        });
        this.overwriteMethod(classNode, "createBlockState", "func_180661_e", "()Lnet/minecraft/block/state/BlockStateContainer;", adapter -> adapter.loadThis());
        this.overwriteMethod(classNode, "getMetaFromState", "func_176201_c", "(Lnet/minecraft/block/state/IBlockState;)I", adapter -> adapter.loadArg(0));
        this.overwriteMethod(classNode, "getStateFromMeta", "func_176203_a", "(I)Lnet/minecraft/block/state/IBlockState;", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
        });
        this.overwriteMethod(classNode, "getStateForPlacement", "func_180642_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;FFFILnet/minecraft/entity/EntityLivingBase;)Lnet/minecraft/block/state/IBlockState;", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
            adapter.loadArg(7);
        });
        this.overwriteMethod(classNode, "getBoundingBox", "func_185496_a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/AxisAlignedBB;", adapter -> adapter.loadArg(0));
        this.overwriteMethod(classNode, "getContainer", "func_189418_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Z)Lnet/minecraft/world/ILockableContainer;", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
        });
        this.overwriteMethod(classNode, "isDoubleChest", "func_176454_e", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
        });
        this.overwriteMethod(classNode, "neighborChanged", "func_189540_a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;)V", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
            adapter.loadArg(4);
        });
        this.overwriteMethod(classNode, "onBlockAdded", "func_180633_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
        });
        this.overwriteMethod(classNode, "onBlockPlacedBy", "func_180633_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", adapter -> {
            adapter.loadArg(0);
            adapter.loadArg(1);
            adapter.loadArg(2);
            adapter.loadArg(4);
        });
    }

    public static final class Hooks {
        @Nonnull
        public static IBlockState checkForSurroundingChests(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            if (world.field_72995_K) {
                return state;
            }
            IBlockState replacement = Hooks.sidelessCheckForSurroundingChests((IBlockSource)new BlockSource(world, pos, state));
            if (replacement != null) {
                world.func_175656_a(pos, replacement);
                return replacement;
            }
            return state;
        }

        @Nonnull
        public static BlockStateContainer createBlockState(@Nonnull BlockChest block) {
            return new BlockStateContainer((Block)block, new IProperty[]{BlockChest.field_176459_a, ChestType.TYPE});
        }

        public static int getMetaFromState(@Nonnull IBlockState state) {
            return ((EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a)).func_176736_b() | ChestType.get(state).index() << 2;
        }

        @Nonnull
        public static IBlockState getStateFromMeta(@Nonnull BlockChest block, int meta) {
            return block.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.fromIndex(meta >> 2)));
        }

        @Nonnull
        public static IBlockState getStateForPlacement(@Nonnull BlockChest block, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EntityLivingBase placer) {
            Pair<EnumFacing, ChestType> properties = Hooks.getPropertiesForPlacement(placer, side, facing -> {
                BlockSource other;
                BlockSource chest = new BlockSource(world, pos, block.func_176223_P(), null);
                return ((IChestMatchable)block).chestMatches((IBlockSource)chest, (IBlockSource)(other = new BlockSource(world, pos.func_177972_a(facing)))) && !ChestType.get(other.func_189992_e()).hasSideAttached() ? (EnumFacing)other.func_189992_e().func_177229_b((IProperty)BlockChest.field_176459_a) : null;
            });
            return block.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)properties.getLeft()).func_177226_a(ChestType.TYPE, (Comparable)properties.getRight());
        }

        @Nonnull
        public static Pair<EnumFacing, ChestType> getPropertiesForPlacement(@Nonnull EntityLivingBase placer, @Nonnull EnumFacing side, @Nonnull UnaryOperator<EnumFacing> directionToAttach) {
            EnumFacing sideToAttach;
            boolean isSneaking = placer.func_70093_af();
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            ChestType type = ChestType.SINGLE;
            if (side.func_176740_k().func_176722_c() && isSneaking && (sideToAttach = (EnumFacing)directionToAttach.apply(side.func_176734_d())) != null && sideToAttach.func_176740_k() != side.func_176740_k()) {
                facing = sideToAttach;
                ChestType chestType = type = sideToAttach.func_176735_f() == side.func_176734_d() ? ChestType.RIGHT : ChestType.LEFT;
            }
            if (type == ChestType.SINGLE && !isSneaking) {
                EnumFacing left = (EnumFacing)directionToAttach.apply(facing.func_176746_e());
                if (left != null && facing != left.func_176734_d()) {
                    type = ChestType.LEFT;
                } else {
                    EnumFacing right = (EnumFacing)directionToAttach.apply(facing.func_176735_f());
                    if (right != null && facing != right.func_176734_d()) {
                        type = ChestType.RIGHT;
                    }
                }
            }
            return Pair.of((Object)facing, (Object)((Object)type));
        }

        @Nonnull
        public static AxisAlignedBB getBoundingBox(@Nonnull IBlockState state) {
            ChestType type = ChestType.get(state);
            if (!type.hasSideAttached()) {
                return BlockChest.field_185561_f;
            }
            switch (type.getSideAttached(state)) {
                case NORTH: {
                    return BlockChest.field_185557_b;
                }
                case SOUTH: {
                    return BlockChest.field_185558_c;
                }
                case EAST: {
                    return BlockChest.field_185560_e;
                }
                case WEST: {
                    return BlockChest.field_185559_d;
                }
            }
            throw new IllegalStateException("What the fuck?");
        }

        @Nullable
        public static ILockableContainer getContainer(@Nonnull BlockChest block, @Nonnull World world, @Nonnull BlockPos pos, boolean allowBlocking) {
            return Hooks.getContainer(block, world, pos, allowBlocking, "container.chestDouble");
        }

        @Nullable
        public static ILockableContainer getContainer(@Nonnull BlockChest block, @Nonnull World world, @Nonnull BlockPos pos, boolean allowBlocking, @Nonnull String nameKey) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileEntityChest) || !allowBlocking && block.func_176457_m(world, pos)) {
                return null;
            }
            IBlockState chest = world.func_180495_p(pos);
            ChestType type = ChestType.get(chest);
            if (!type.hasSideAttached()) {
                return (ILockableContainer)tile;
            }
            EnumFacing sideAttached = type.getSideAttached(chest);
            BlockPos attached = pos.func_177972_a(sideAttached);
            if (!allowBlocking && block.func_176457_m(world, attached)) {
                return null;
            }
            TileEntity neighbor = world.func_175625_s(attached);
            if (!(neighbor instanceof TileEntityChest)) {
                return (ILockableContainer)tile;
            }
            return sideAttached.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? new InventoryLargeChest(nameKey, (ILockableContainer)tile, (ILockableContainer)neighbor) : new InventoryLargeChest(nameKey, (ILockableContainer)neighbor, (ILockableContainer)tile);
        }

        public static boolean isDoubleChest(@Nonnull BlockChest block, @Nonnull World world, @Nonnull BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177230_c() == block && ChestType.get(state).hasSideAttached();
        }

        public static void neighborChanged(@Nonnull BlockChest block, @Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
            IBlockState other;
            ChestType type;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityChest) {
                tile.func_145836_u();
            }
            if ((type = ChestType.get(state)).hasSideAttached() && pos.func_177972_a(type.getSideAttached(state)).equals((Object)otherPos) && (!IChestMatchable.chestMatches(block, world, state, pos, other = world.func_180495_p(otherPos), otherPos) || state.func_177229_b((IProperty)BlockChest.field_176459_a) != other.func_177229_b((IProperty)BlockChest.field_176459_a) || type.getOpposite() != ChestType.get(other))) {
                world.func_175656_a(pos, state.func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.SINGLE)));
            }
        }

        public static void onBlockAdded(@Nonnull BlockChest block, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            block.func_176455_e(worldIn, pos, state);
            BlockSource chest = new BlockSource(worldIn, pos);
            for (EnumFacing side : EnumFacing.field_176754_o) {
                BlockSource other = new BlockSource(worldIn, pos.func_177972_a(side));
                if (!((IChestMatchable)block).chestMatches((IBlockSource)chest, (IBlockSource)other)) continue;
                block.func_176455_e(worldIn, other.func_180699_d(), other.func_189992_e());
            }
        }

        public static void onBlockPlacedBy(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull ItemStack stack) {
            TileEntity tile;
            if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof TileEntityChest) {
                ((TileEntityChest)tile).func_190575_a(stack.func_82833_r());
            }
        }

        @Nullable
        public static IBlockState sidelessCheckForSurroundingChests(@Nonnull IBlockSource chest) {
            ChestType neighborType;
            ChestType neighborType2;
            ChestType neighborType3;
            ChestType neighborType4;
            World world = chest.func_82618_k();
            BlockPos pos = chest.func_180699_d();
            IBlockState state = chest.func_189992_e();
            ChestType type = ChestType.get(state);
            switch (type) {
                case LEFT: 
                case RIGHT: {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a);
                    EnumFacing attached = type.getSideAttached(facing);
                    BlockSource other = new BlockSource(world, pos.func_177972_a(attached));
                    if (!((IChestMatchable)state.func_177230_c()).chestMatches(chest, (IBlockSource)other)) {
                        return null;
                    }
                    ChestType neighborType5 = ChestType.get(other.func_189992_e());
                    if (neighborType5.hasSideAttached() && neighborType5.getSideAttached(other.func_189992_e()) != attached.func_176734_d()) break;
                    return null;
                }
            }
            BlockSource north = new BlockSource(world, pos.func_177978_c());
            boolean northMatches = ((IChestMatchable)state.func_177230_c()).chestMatches(chest, (IBlockSource)north);
            if (northMatches && (neighborType4 = ChestType.get(north.func_189992_e())).hasSideAttached() && neighborType4.getSideAttached(north.func_189992_e()) == EnumFacing.SOUTH) {
                return state.func_177226_a((IProperty)BlockChest.field_176459_a, north.func_189992_e().func_177229_b((IProperty)BlockChest.field_176459_a)).func_177226_a(ChestType.TYPE, (Comparable)((Object)neighborType4.getOpposite()));
            }
            BlockSource south = new BlockSource(world, pos.func_177968_d());
            boolean southMatches = ((IChestMatchable)state.func_177230_c()).chestMatches(chest, (IBlockSource)south);
            if (southMatches && (neighborType3 = ChestType.get(south.func_189992_e())).hasSideAttached() && neighborType3.getSideAttached(south.func_189992_e()) == EnumFacing.NORTH) {
                return state.func_177226_a((IProperty)BlockChest.field_176459_a, south.func_189992_e().func_177229_b((IProperty)BlockChest.field_176459_a)).func_177226_a(ChestType.TYPE, (Comparable)((Object)neighborType3.getOpposite()));
            }
            BlockSource east = new BlockSource(world, pos.func_177974_f());
            boolean eastMatches = ((IChestMatchable)state.func_177230_c()).chestMatches(chest, (IBlockSource)east);
            if (eastMatches && (neighborType2 = ChestType.get(east.func_189992_e())).hasSideAttached() && neighborType2.getSideAttached(east.func_189992_e()) == EnumFacing.WEST) {
                return state.func_177226_a((IProperty)BlockChest.field_176459_a, east.func_189992_e().func_177229_b((IProperty)BlockChest.field_176459_a)).func_177226_a(ChestType.TYPE, (Comparable)((Object)neighborType2.getOpposite()));
            }
            BlockSource west = new BlockSource(world, pos.func_177976_e());
            boolean westMatches = ((IChestMatchable)state.func_177230_c()).chestMatches(chest, (IBlockSource)west);
            if (westMatches && (neighborType = ChestType.get(west.func_189992_e())).hasSideAttached() && neighborType.getSideAttached(west.func_189992_e()) == EnumFacing.EAST) {
                return state.func_177226_a((IProperty)BlockChest.field_176459_a, west.func_189992_e().func_177229_b((IProperty)BlockChest.field_176459_a)).func_177226_a(ChestType.TYPE, (Comparable)((Object)neighborType.getOpposite()));
            }
            if (type == ChestType.SINGLE) {
                return null;
            }
            if (northMatches && !ChestType.get(north.func_189992_e()).hasSideAttached()) {
                return Hooks.getStateWithFacing(state, north.func_189992_e(), EnumFacing.EAST, ChestType.RIGHT);
            }
            if (southMatches && !ChestType.get(south.func_189992_e()).hasSideAttached()) {
                return Hooks.getStateWithFacing(state, south.func_189992_e(), EnumFacing.EAST, ChestType.LEFT);
            }
            if (eastMatches && !ChestType.get(east.func_189992_e()).hasSideAttached()) {
                return Hooks.getStateWithFacing(state, east.func_189992_e(), EnumFacing.SOUTH, ChestType.RIGHT);
            }
            if (westMatches && !ChestType.get(west.func_189992_e()).hasSideAttached()) {
                return Hooks.getStateWithFacing(state, west.func_189992_e(), EnumFacing.SOUTH, ChestType.LEFT);
            }
            return state.func_177226_a(ChestType.TYPE, (Comparable)((Object)ChestType.SINGLE));
        }

        @Nonnull
        private static IBlockState getStateWithFacing(@Nonnull IBlockState chest, @Nonnull IBlockState other, @Nonnull EnumFacing fallback, @Nonnull ChestType fallbackType) {
            EnumFacing currentFacing = (EnumFacing)chest.func_177229_b((IProperty)BlockChest.field_176459_a);
            EnumFacing neighborFacing = (EnumFacing)other.func_177229_b((IProperty)BlockChest.field_176459_a);
            if (currentFacing.func_176740_k() == fallback.func_176740_k()) {
                return chest.func_177226_a(ChestType.TYPE, (Comparable)((Object)(currentFacing == fallback ? fallbackType : fallbackType.getOpposite())));
            }
            if (neighborFacing.func_176740_k() == fallback.func_176740_k()) {
                return chest.func_177226_a(ChestType.TYPE, (Comparable)((Object)(neighborFacing == fallback ? fallbackType : fallbackType.getOpposite()))).func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)neighborFacing);
            }
            return chest.func_177226_a(ChestType.TYPE, (Comparable)((Object)fallbackType)).func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)fallback);
        }
    }
}

