/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.asm.transformers.vanilla;

import git.jbredwards.friendly_chests.api.ChestType;
import git.jbredwards.friendly_chests.api.IChestMatchable;
import git.jbredwards.friendly_chests.mod.asm.transformers.IASMClassTransformer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.objectweb.asm.tree.ClassNode;

public final class TransformerTileEntityChest
implements IASMClassTransformer {
    @Override
    public void transform(@Nonnull ClassNode classNode) {
        this.overwriteMethod(classNode, "getAdjacentChest", "func_174911_a", "(Lnet/minecraft/util/EnumFacing;)Lnet/minecraft/tileentity/TileEntityChest;", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
        });
        this.overwriteMethod(classNode, "getBlockMetadata", "func_145832_p", "()I", adapter -> {
            adapter.loadThis();
            adapter.loadThis();
            adapter.visitMethodInsn(183, classNode.superName, DEOBFUSCATED ? "getBlockMetadata" : "func_145832_p", "()I", false);
        });
        this.overwriteMethod(classNode, "isChestAt", "func_174912_b", "(Lnet/minecraft/util/math/BlockPos;)Z", adapter -> {
            adapter.loadThis();
            adapter.loadArg(0);
        });
        this.overwriteMethod(classNode, "shouldRefresh", "shouldRefresh", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;)Z", adapter -> {
            adapter.loadArg(2);
            adapter.loadArg(3);
        });
    }

    public static final class Hooks {
        @Nullable
        public static TileEntityChest getAdjacentChest(@Nonnull TileEntityChest tile, @Nonnull EnumFacing direction) {
            if (!tile.func_145830_o()) {
                return null;
            }
            BlockPos offset = tile.func_174877_v().func_177972_a(direction);
            TileEntity neighbor = tile.func_145831_w().func_175625_s(offset);
            if (neighbor instanceof TileEntityChest) {
                if (Hooks.isChestAt(tile, offset)) {
                    ((TileEntityChest)neighbor).func_174910_a(tile, direction);
                    return (TileEntityChest)neighbor;
                }
                switch (direction.func_176734_d()) {
                    case NORTH: {
                        ((TileEntityChest)neighbor).field_145992_i = null;
                        break;
                    }
                    case SOUTH: {
                        ((TileEntityChest)neighbor).field_145988_l = null;
                        break;
                    }
                    case EAST: {
                        ((TileEntityChest)neighbor).field_145990_j = null;
                        break;
                    }
                    case WEST: {
                        ((TileEntityChest)neighbor).field_145991_k = null;
                    }
                }
            }
            return null;
        }

        public static int getBlockMetadata(@Nonnull TileEntityChest tile, int realMeta) {
            return tile.func_145831_w().field_72995_K && tile.func_145838_q() instanceof BlockChest ? EnumFacing.func_176731_b((int)(realMeta & 3)).func_176745_a() : realMeta;
        }

        public static boolean isChestAt(@Nonnull TileEntityChest tile, @Nonnull BlockPos pos) {
            if (!tile.func_145830_o() || !(tile.func_145838_q() instanceof BlockChest)) {
                return false;
            }
            tile.func_145832_p();
            ChestType type = ChestType.fromOrdinal(tile.field_145847_g >> 2);
            if (!type.hasSideAttached() || !tile.func_174877_v().func_177972_a(type.getSideAttached(EnumFacing.func_176731_b((int)(tile.field_145847_g & 3)))).equals((Object)pos)) {
                return false;
            }
            IBlockState neighbor = tile.func_145831_w().func_180495_p(pos);
            if (!IChestMatchable.chestMatches((BlockChest)tile.func_145838_q(), tile.func_145831_w(), tile.func_145838_q().func_176203_a(tile.field_145847_g), tile.func_174877_v(), neighbor, pos)) {
                return false;
            }
            ChestType neighborType = ChestType.get(neighbor);
            return neighborType.hasOpposite() && neighborType.getOpposite() == type;
        }

        public static boolean shouldRefresh(@Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
            return oldState.func_177230_c() instanceof BlockChest ? oldState.func_177230_c() != newState.func_177230_c() : oldState != newState;
        }
    }
}

