/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.client;

import git.jbredwards.friendly_chests.api.ChestType;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IRegistryDelegate;

@Mod.EventBusSubscriber(modid="friendly_chests", value={Side.CLIENT})
public final class ClientEventHandler {
    @SideOnly(value=Side.CLIENT)
    static final Map<IRegistryDelegate<Block>, IStateMapper> customStateMappers = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelLoader.class, null, (String)"customStateMappers");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    static void handleBakedModels(@Nonnull ModelRegistryEvent event) {
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof BlockChest)) continue;
            IStateMapper mapper = customStateMappers.get(block.delegate);
            if (mapper instanceof StateMap) {
                ((StateMap)mapper).field_178140_d.add(ChestType.TYPE);
                continue;
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{ChestType.TYPE}).func_178441_a());
        }
    }
}

