/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.common.capability;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityProvider<T>
implements ICapabilitySerializable<NBTBase> {
    @Nonnull
    public final Capability<T> capability;
    @Nonnull
    public final T instance;
    @Nullable
    public final EnumFacing face;

    public CapabilityProvider(@Nullable Capability<T> capabilityIn) {
        this(capabilityIn, null);
    }

    public CapabilityProvider(@Nullable Capability<T> capabilityIn, @Nullable T instanceIn) {
        this(capabilityIn, instanceIn, null);
    }

    public CapabilityProvider(@Nullable Capability<T> capabilityIn, @Nullable T instanceIn, @Nullable EnumFacing faceIn) {
        this.capability = (Capability)Preconditions.checkNotNull(capabilityIn, (Object)"Capability is null, this should never happen!");
        this.instance = instanceIn != null ? instanceIn : Preconditions.checkNotNull((Object)this.capability.getDefaultInstance(), (String)"Default instance of capability \"%s\" returned null: ", (Object)this.capability.getName());
        this.face = faceIn;
    }

    public boolean hasCapability(@Nullable Capability<?> capabilityIn, @Nullable EnumFacing faceIn) {
        return capabilityIn == this.capability && this.face == faceIn;
    }

    @Nullable
    public <t> t getCapability(@Nullable Capability<t> capabilityIn, @Nullable EnumFacing faceIn) {
        if (!this.hasCapability(capabilityIn, faceIn)) {
            return null;
        }
        return (t)this.capability.cast(this.instance);
    }

    @Nonnull
    public NBTBase serializeNBT() {
        return (NBTBase)Preconditions.checkNotNull((Object)this.capability.writeNBT(this.instance, this.face), (String)"NBT for capability \"%s\" returned null, please fix it: ", (Object)this.capability.getName());
    }

    public void deserializeNBT(@Nullable NBTBase nbt) {
        this.capability.readNBT(this.instance, this.face, nbt);
    }
}

