/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.common.capability;

import git.jbredwards.friendly_chests.mod.common.capability.CapabilityProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public interface IFriendlyChestCapability {
    @CapabilityInject(value=IFriendlyChestCapability.class)
    @Nonnull
    public static final Capability<IFriendlyChestCapability> CAPABILITY = null;
    @Nonnull
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("friendly_chests", "fixed");

    public boolean isFixed();

    public void setFixed(boolean var1);

    @Nullable
    public static IFriendlyChestCapability get(@Nullable TileEntity tile) {
        return tile != null && tile.hasCapability(CAPABILITY, null) ? (IFriendlyChestCapability)tile.getCapability(CAPABILITY, null) : null;
    }

    @Nullable
    public static IFriendlyChestCapability get(@Nullable Chunk chunk) {
        return chunk != null && chunk.hasCapability(CAPABILITY, null) ? (IFriendlyChestCapability)chunk.getCapability(CAPABILITY, null) : null;
    }

    @SubscribeEvent
    public static void attachChunk(@Nonnull AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(CAPABILITY_ID, new CapabilityProvider<IFriendlyChestCapability>(CAPABILITY));
    }

    @SubscribeEvent
    public static void attachTile(@Nonnull AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityChest) {
            event.addCapability(CAPABILITY_ID, new CapabilityProvider<IFriendlyChestCapability>(CAPABILITY));
        }
    }

    public static enum Storage implements Capability.IStorage<IFriendlyChestCapability>
    {
        INSTANCE;


        @Nonnull
        public NBTBase writeNBT(@Nonnull Capability<IFriendlyChestCapability> capability, @Nonnull IFriendlyChestCapability instance, @Nullable EnumFacing side) {
            return new NBTTagInt(instance.isFixed() ? 1 : 0);
        }

        public void readNBT(@Nonnull Capability<IFriendlyChestCapability> capability, @Nonnull IFriendlyChestCapability instance, @Nullable EnumFacing side, @Nullable NBTBase nbt) {
            instance.setFixed(nbt instanceof NBTPrimitive && ((NBTPrimitive)nbt).func_150287_d() != 0);
        }
    }

    public static class Impl
    implements IFriendlyChestCapability {
        boolean fixed = true;

        @Override
        public boolean isFixed() {
            return this.fixed;
        }

        @Override
        public void setFixed(boolean fixedIn) {
            this.fixed = fixedIn;
        }
    }
}

