/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.friendly_chests.mod.common.datafixer;

import git.jbredwards.friendly_chests.api.ChestType;
import git.jbredwards.friendly_chests.api.IChestMatchable;
import git.jbredwards.friendly_chests.mod.common.capability.IFriendlyChestCapability;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="friendly_chests")
public final class ChestDataFixer {
    @SubscribeEvent(priority=EventPriority.HIGH)
    static void applyFix(@Nonnull ChunkEvent.Load event) {
        Chunk chunk = event.getChunk();
        IFriendlyChestCapability chunkCap = IFriendlyChestCapability.get(chunk);
        if (chunkCap == null || chunkCap.isFixed()) {
            return;
        }
        World world = event.getWorld();
        for (Map.Entry entry2 : (Map.Entry[])chunk.func_177434_r().entrySet().stream().filter(entry -> entry.getValue() instanceof TileEntityChest && !((TileEntity)entry.getValue()).func_145837_r()).toArray(Map.Entry[]::new)) {
            BlockPos pos = (BlockPos)entry2.getKey();
            IFriendlyChestCapability cap = IFriendlyChestCapability.get((TileEntity)entry2.getValue());
            if (cap == null || cap.isFixed()) continue;
            IBlockState state = chunk.func_177435_g(pos);
            if (state.func_177230_c() instanceof BlockChest) {
                EnumFacing facing = EnumFacing.func_82600_a((int)state.func_177230_c().func_176201_c(state));
                if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                    facing = EnumFacing.NORTH;
                }
                state = state.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing);
                ChestType type = ChestType.SINGLE;
                if (ChestDataFixer.fixSide(state, world, chunk, pos, facing, ChestType.RIGHT)) {
                    type = ChestType.RIGHT;
                } else if (ChestDataFixer.fixSide(state, world, chunk, pos, facing, ChestType.LEFT)) {
                    type = ChestType.LEFT;
                }
                state = state.func_177226_a(ChestType.TYPE, (Comparable)((Object)type));
                chunk.func_177436_a(pos, state);
            }
            cap.setFixed(true);
        }
        chunkCap.setFixed(true);
    }

    static boolean fixSide(@Nonnull IBlockState state, @Nonnull World world, @Nonnull Chunk chunk, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, @Nonnull ChestType type) {
        Chunk otherChunk;
        BlockPos otherPos = pos.func_177972_a(type.getSideAttached(facing));
        Chunk chunk2 = otherChunk = chunk.func_76600_a(otherPos.func_177958_n() >> 4, otherPos.func_177952_p() >> 4) ? chunk : world.func_72863_F().func_186026_b(otherPos.func_177958_n() >> 4, otherPos.func_177952_p() >> 4);
        if (otherChunk != null) {
            IFriendlyChestCapability cap;
            IBlockState otherState = otherChunk.func_177435_g(otherPos);
            if (IChestMatchable.chestMatches((BlockChest)state.func_177230_c(), world, state, pos, otherState, otherPos) && (cap = IFriendlyChestCapability.get(otherChunk.func_177424_a(otherPos, Chunk.EnumCreateEntityType.CHECK))) != null && !cap.isFixed()) {
                otherChunk.func_177436_a(otherPos, otherState.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing).func_177226_a(ChestType.TYPE, (Comparable)((Object)type.getOpposite())));
                cap.setFixed(true);
                return true;
            }
        }
        return false;
    }
}

