/*
 * Decompiled with CFR 0.152.
 */
package syzez.autoslayingdeluxe;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import syzez.autoslayingdeluxe.Failsafes.Failsafe_MoblessTimeout;
import syzez.autoslayingdeluxe.Failsafes.Failsafe_Teleport;
import syzez.autoslayingdeluxe.MouseUngrabber;
import syzez.autoslayingdeluxe.PetActivator;
import syzez.autoslayingdeluxe.Util.Config;
import syzez.autoslayingdeluxe.Util.PushNotifications;

public class SlayingLogic {
    private static final class_310 client = class_310.method_1551();
    private static boolean slayingActive = false;
    private static class_304 toggleSlayKey;
    private static long lastAttackTimeNs;
    private static double currentCPS;
    private static long nextCpsUpdateTime;
    private static long lastValidTargetTimeMs;
    private static final Random random;
    private static float baseYaw;
    private static float basePitch;
    static boolean shouldJitter;
    static class_1297 jitterTarget;
    private static int initialSelectedSlot;
    private static long slayStartTime;
    private static int entityKillCount;
    private static boolean isPaused;
    private static long lastCheckTime;
    private static long petCheckInterval;
    private static final Map<Integer, Integer> trackedStackCounts;

    public static boolean isMouseJitterInEffect() {
        return shouldJitter;
    }

    public static void register() {
        toggleSlayKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.autoslayingdeluxe.toggleslaying", class_3675.class_307.field_1668, 75, "category.autoslayingdeluxe"));
        ClientTickEvents.END_CLIENT_TICK.register(c -> {
            double distanceSquared;
            class_1297 target;
            long intervalNs;
            long nowNs;
            long delayMs;
            double maxRange;
            while (toggleSlayKey.method_1436()) {
                boolean bl = slayingActive = !slayingActive;
                if (slayingActive && SlayingLogic.client.field_1724 != null) {
                    baseYaw = SlayingLogic.client.field_1724.method_36454();
                    basePitch = SlayingLogic.client.field_1724.method_36455();
                    initialSelectedSlot = SlayingLogic.client.field_1724.method_31548().method_67532();
                    SlayingLogic.resetSlaySession();
                    Failsafe_MoblessTimeout.resetTimer();
                    Failsafe_Teleport.reset();
                    lastCheckTime = System.currentTimeMillis();
                    PushNotifications.show("Started Slaying");
                    if (!MouseUngrabber.isEnabled()) continue;
                    MouseUngrabber.ungrabMouse();
                    continue;
                }
                PushNotifications.show("Stopped Slaying");
            }
            long now = System.currentTimeMillis();
            if (!slayingActive && !PetActivator.isBusy() || SlayingLogic.client.field_1724 == null || SlayingLogic.client.field_1687 == null) {
                return;
            }
            if (PetActivator.isBusy()) {
                return;
            }
            if (Config.getInstance().isPetActivatorEnabled() && now - lastCheckTime >= petCheckInterval) {
                lastCheckTime = now;
                petCheckInterval = 300000L + (long)(random.nextInt(31000) - 15000);
                SlayingLogic.pauseSlaying();
                PushNotifications.show("Checking Pet...");
                PetActivator.startCheckWithResume();
                return;
            }
            if (now >= nextCpsUpdateTime) {
                int max;
                int min = Config.getInstance().getMinCPS();
                if (min > (max = Config.getInstance().getMaxCPS())) {
                    min = max;
                }
                currentCPS = min + random.nextInt(max - min + 1);
                nextCpsUpdateTime = now + 1000L;
            }
            if (SlayingLogic.client.field_1765 != null && SlayingLogic.client.field_1765.method_17783() == class_239.class_240.field_1331) {
                class_1297 target2 = ((class_3966)SlayingLogic.client.field_1765).method_17782();
                if (!SlayingLogic.isGroupAllowed(target2)) {
                    return;
                }
                double distanceSquared2 = SlayingLogic.client.field_1724.method_5858(target2);
                if (distanceSquared2 <= (maxRange = Config.getInstance().getTargetRange()) * maxRange) {
                    long intervalNs2;
                    lastValidTargetTimeMs = now;
                    long nowNs2 = System.nanoTime();
                    if (nowNs2 - lastAttackTimeNs >= (intervalNs2 = (long)(1.0E9 / currentCPS))) {
                        if (SlayingLogic.client.field_1761 != null) {
                            SlayingLogic.client.field_1761.method_2918((class_1657)SlayingLogic.client.field_1724, target2);
                            int entityId = target2.method_5628();
                            int currentStack = SlayingLogic.parseStackCountFromName(target2);
                            trackedStackCounts.putIfAbsent(entityId, currentStack);
                        }
                        SlayingLogic.client.field_1724.method_6104(class_1268.field_5808);
                        lastAttackTimeNs = nowNs2;
                    }
                }
            }
            if (Config.getInstance().isClickDelayEnabled() && now - lastValidTargetTimeMs <= (delayMs = (long)Config.getInstance().getClickDelaySeconds() * 1000L) && (nowNs = System.nanoTime()) - lastAttackTimeNs >= (intervalNs = (long)(1.0E9 / currentCPS))) {
                SlayingLogic.client.field_1724.method_6104(class_1268.field_5808);
                lastAttackTimeNs = nowNs;
            }
            shouldJitter = false;
            jitterTarget = null;
            if (Config.getInstance().isMouseJitterEnabled() && SlayingLogic.client.field_1765 != null && SlayingLogic.client.field_1765.method_17783() == class_239.class_240.field_1331 && SlayingLogic.isGroupAllowed(target = ((class_3966)SlayingLogic.client.field_1765).method_17782()) && (distanceSquared = SlayingLogic.client.field_1724.method_5858(target)) <= (maxRange = Config.getInstance().getTargetRange()) * maxRange) {
                shouldJitter = true;
                jitterTarget = target;
                if (baseYaw == 0.0f && basePitch == 0.0f) {
                    baseYaw = SlayingLogic.client.field_1724.method_36454();
                    basePitch = SlayingLogic.client.field_1724.method_36455();
                }
            }
            if (shouldJitter) {
                if (random.nextInt(8) == 0) {
                    if (baseYaw == 0.0f && basePitch == 0.0f && SlayingLogic.client.field_1724 != null) {
                        baseYaw = SlayingLogic.client.field_1724.method_36454();
                        basePitch = SlayingLogic.client.field_1724.method_36455();
                    }
                    float yawJitter = (random.nextFloat() - 0.5f) * 0.5f;
                    float pitchJitter = (random.nextFloat() - 0.5f) * 0.4f;
                    float newYaw = SlayingLogic.client.field_1724.method_36454() + yawJitter;
                    float newPitch = SlayingLogic.client.field_1724.method_36455() + pitchJitter;
                    newYaw = Math.max(baseYaw - 1.5f, Math.min(baseYaw + 1.5f, newYaw));
                    newPitch = Math.max(basePitch - 1.0f, Math.min(basePitch + 1.0f, newPitch));
                    SlayingLogic.client.field_1724.method_36456(newYaw);
                    SlayingLogic.client.field_1724.method_36457(newPitch);
                }
            } else if (baseYaw != 0.0f || basePitch != 0.0f) {
                SlayingLogic.client.field_1724.method_36456(baseYaw);
                SlayingLogic.client.field_1724.method_36457(basePitch);
                baseYaw = 0.0f;
                basePitch = 0.0f;
            }
            if (SlayingLogic.client.field_1724 == null || SlayingLogic.client.field_1687 == null) {
                return;
            }
            double range = Config.getInstance().getTargetRange();
            for (class_1297 entity : SlayingLogic.client.field_1687.method_18112()) {
                int previousStack;
                if (!entity.method_5805() || entity.method_31481() || SlayingLogic.client.field_1724.method_5858(entity) > range * range) continue;
                int id = entity.method_5628();
                int currentStack = SlayingLogic.parseStackCountFromName(entity);
                if (currentStack < (previousStack = trackedStackCounts.getOrDefault(id, currentStack).intValue())) {
                    int delta = previousStack - currentStack;
                    SlayingLogic.incrementKillCountBy(delta);
                }
                trackedStackCounts.put(id, currentStack);
            }
        });
    }

    private static boolean isGroupAllowed(class_1297 entity) {
        if (SlayingLogic.isHostile(entity)) {
            return Config.getInstance().getMobCategoryToggles().getOrDefault("Hostile Mobs", false);
        }
        if (SlayingLogic.isNeutral(entity)) {
            return Config.getInstance().getMobCategoryToggles().getOrDefault("Neutral Mobs", false);
        }
        if (SlayingLogic.isPassive(entity)) {
            return Config.getInstance().getMobCategoryToggles().getOrDefault("Passive Mobs", false);
        }
        return false;
    }

    private static boolean isHostile(class_1297 entity) {
        return entity instanceof class_1588;
    }

    private static boolean isNeutral(class_1297 entity) {
        class_1299 type = entity.method_5864();
        return type == class_1299.field_6091 || type == class_1299.field_22281 || type == class_1299.field_20346 || type == class_1299.field_6055 || type == class_1299.field_30052 || type == class_1299.field_6074 || type == class_1299.field_6087;
    }

    private static boolean isPassive(class_1297 entity) {
        return entity instanceof class_1296 && !SlayingLogic.isNeutral(entity);
    }

    public static boolean isSlayingActive() {
        return slayingActive && !isPaused;
    }

    public static void stopSlaying() {
        slayingActive = false;
        baseYaw = 0.0f;
        basePitch = 0.0f;
        SlayingLogic.resetSlaySession();
        Failsafe_MoblessTimeout.resetTimer();
        Failsafe_Teleport.reset();
        lastCheckTime = System.currentTimeMillis();
    }

    public static int getInitialSelectedSlot() {
        return initialSelectedSlot;
    }

    public static boolean isValidTarget(class_1308 mob, class_1657 player, double range) {
        if (mob == null || !mob.method_5805() || mob.method_31481() || mob.method_5767()) {
            return false;
        }
        if (!SlayingLogic.isGroupAllowed((class_1297)mob)) {
            return false;
        }
        double distanceSquared = player.method_5858((class_1297)mob);
        return distanceSquared <= range * range;
    }

    public static void forceLeftClick() {
        if (SlayingLogic.client.field_1724 != null) {
            SlayingLogic.client.field_1724.method_6104(class_1268.field_5808);
        }
    }

    private static int parseStackCountFromName(class_1297 entity) {
        String[] tokens;
        if (entity == null || !entity.method_16914()) {
            return 1;
        }
        String name = Objects.requireNonNull(entity.method_5797()).getString();
        name = name.replaceAll("\u00a7.", "");
        for (String token : tokens = name.split(" ")) {
            if (token.matches("x\\d+")) {
                try {
                    return Integer.parseInt(token.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!token.matches("\\d+x")) continue;
            try {
                return Integer.parseInt(token.substring(0, token.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    public static void incrementKillCountBy(int amount) {
        entityKillCount += amount;
    }

    public static long getSlayStartTime() {
        return slayStartTime;
    }

    public static int getKillCount() {
        return entityKillCount;
    }

    public static void resetSlaySession() {
        slayStartTime = System.currentTimeMillis();
        entityKillCount = 0;
    }

    public static boolean isPaused() {
        return isPaused;
    }

    public static void pauseSlaying() {
        isPaused = true;
    }

    public static void resumeSlaying() {
        isPaused = false;
    }

    public static boolean isSlayingToggled() {
        return slayingActive;
    }

    static {
        lastAttackTimeNs = 0L;
        currentCPS = 10.0;
        nextCpsUpdateTime = 0L;
        lastValidTargetTimeMs = 0L;
        random = new Random();
        baseYaw = 0.0f;
        basePitch = 0.0f;
        shouldJitter = false;
        jitterTarget = null;
        initialSelectedSlot = -1;
        slayStartTime = 0L;
        entityKillCount = 0;
        isPaused = false;
        lastCheckTime = 0L;
        petCheckInterval = 0L;
        trackedStackCounts = new HashMap<Integer, Integer>();
    }
}

