/*
 * Decompiled with CFR 0.152.
 */
package syzez.autoslayingdeluxe.Util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import syzez.autoslayingdeluxe.AutoSlayingDeluxe;

public class Config {
    private int clicksPerSecond = 2;
    private double targetRange = 3.0;
    private int minCPS = 2;
    private int maxCPS = 3;
    private boolean enableMouseJitter = false;
    private boolean showOverlay = true;
    private float soundVolume = 1.0f;
    private SoundLoopMode soundLoopMode = SoundLoopMode.ONCE;
    private int soundLoopAmount = 3;
    private boolean failsafeGUIEnabled = true;
    private boolean breakProtectionEnabled = true;
    private boolean inventoryFullFailsafeEnabled = true;
    private boolean itemSwapFailsafeEnabled = true;
    private boolean mouseUngrabEnabled = false;
    private boolean moblessTimeoutFailsafeEnabled = true;
    private boolean teleportFailsafeEnabled = true;
    private boolean headTurnFailsafeEnabled = true;
    private boolean petActivatorEnabled = true;
    private boolean clickDelayEnabled = false;
    private int clickDelaySeconds = 1;
    private int moblessTimeoutSeconds = 45;
    private HeadTurnMode headTurnMode = HeadTurnMode.SOFT;
    private int hudX = 10;
    private int hudY = 10;
    private boolean hudEditMode = false;
    private Map<String, Boolean> mobCategoryToggles = new HashMap<String, Boolean>(Map.of("Hostile Mobs", true, "Neutral Mobs", false, "Passive Mobs", false));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/autoslayingdeluxe.json");
    private static final Config instance = new Config();

    public int getHudX() {
        return this.hudX;
    }

    public int getHudY() {
        return this.hudY;
    }

    public void setHudX(int x) {
        this.hudX = x;
    }

    public void setHudY(int y) {
        this.hudY = y;
    }

    public boolean isHudEditMode() {
        return this.hudEditMode;
    }

    public void setHudEditMode(boolean edit) {
        this.hudEditMode = edit;
    }

    public void save() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)this, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            AutoSlayingDeluxe.LOGGER.error("[Config] Failed to save config", (Throwable)e);
        }
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Config loaded = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (loaded.clicksPerSecond >= 1 && loaded.clicksPerSecond <= 20) {
                Config.instance.clicksPerSecond = loaded.clicksPerSecond;
            }
            if (loaded.targetRange >= 0.5 && loaded.targetRange <= 5.0) {
                Config.instance.targetRange = loaded.targetRange;
            }
            if (loaded.minCPS >= 1 && loaded.minCPS <= 20) {
                Config.instance.minCPS = loaded.minCPS;
            }
            if (loaded.maxCPS >= loaded.minCPS && loaded.maxCPS <= 20) {
                Config.instance.maxCPS = loaded.maxCPS;
            }
            if (loaded.mobCategoryToggles != null) {
                Config.instance.mobCategoryToggles = loaded.mobCategoryToggles;
            }
            if (loaded.enableMouseJitter) {
                Config.instance.enableMouseJitter = true;
            }
            if (loaded.soundVolume >= 0.0f && loaded.soundVolume <= 1.0f) {
                Config.instance.soundVolume = loaded.soundVolume;
            }
            if (loaded.soundLoopMode != null) {
                Config.instance.soundLoopMode = loaded.soundLoopMode;
            }
            if (loaded.soundLoopAmount > 0) {
                Config.instance.soundLoopAmount = Math.min(loaded.soundLoopAmount, 1000);
            }
            Config.instance.failsafeGUIEnabled = loaded.failsafeGUIEnabled;
            Config.instance.showOverlay = loaded.showOverlay;
            Config.instance.breakProtectionEnabled = loaded.breakProtectionEnabled;
            Config.instance.inventoryFullFailsafeEnabled = loaded.inventoryFullFailsafeEnabled;
            Config.instance.itemSwapFailsafeEnabled = loaded.itemSwapFailsafeEnabled;
            Config.instance.mouseUngrabEnabled = loaded.mouseUngrabEnabled;
            Config.instance.hudX = loaded.hudX;
            Config.instance.hudY = loaded.hudY;
            Config.instance.hudEditMode = loaded.hudEditMode;
            instance.setHudEditMode(false);
            Config.instance.moblessTimeoutFailsafeEnabled = loaded.moblessTimeoutFailsafeEnabled;
            Config.instance.teleportFailsafeEnabled = loaded.teleportFailsafeEnabled;
            Config.instance.headTurnFailsafeEnabled = loaded.headTurnFailsafeEnabled;
            Config.instance.petActivatorEnabled = loaded.petActivatorEnabled;
            if (loaded.headTurnMode != null) {
                Config.instance.headTurnMode = loaded.headTurnMode;
            }
            Config.instance.clickDelayEnabled = loaded.clickDelayEnabled;
            if (loaded.clickDelaySeconds >= 0) {
                Config.instance.clickDelaySeconds = Math.max(0, Math.min(loaded.clickDelaySeconds, 10));
            }
            if (loaded.moblessTimeoutSeconds > 0) {
                Config.instance.moblessTimeoutSeconds = Math.max(5, Math.min(loaded.moblessTimeoutSeconds, 600));
            }
            AutoSlayingDeluxe.LOGGER.info("[Config] Loaded from file.");
        }
        catch (IOException e) {
            AutoSlayingDeluxe.LOGGER.error("[Config] Failed to load config", (Throwable)e);
        }
    }

    public double getTargetRange() {
        return this.targetRange;
    }

    public void setTargetRange(double targetRange) {
        this.targetRange = targetRange;
    }

    public Map<String, Boolean> getMobCategoryToggles() {
        return this.mobCategoryToggles;
    }

    public static Config getInstance() {
        return instance;
    }

    public int getMinCPS() {
        return this.minCPS;
    }

    public int getMaxCPS() {
        return this.maxCPS;
    }

    public void setMinCPS(int value) {
        this.minCPS = Math.max(1, Math.min(value, this.maxCPS));
        this.save();
    }

    public void setMaxCPS(int value) {
        this.maxCPS = Math.min(20, Math.max(value, this.minCPS));
        this.save();
    }

    public boolean isMouseJitterEnabled() {
        return this.enableMouseJitter;
    }

    public void setMouseJitterEnabled(boolean enabled) {
        this.enableMouseJitter = enabled;
        this.save();
    }

    public boolean isShowOverlayEnabled() {
        return this.showOverlay;
    }

    public void setShowOverlayEnabled(boolean enabled) {
        this.showOverlay = enabled;
        this.save();
    }

    public float getSoundVolume() {
        return this.soundVolume;
    }

    public void setSoundVolume(float volume) {
        this.soundVolume = Math.max(0.0f, Math.min(volume, 1.0f));
    }

    public SoundLoopMode getSoundLoopMode() {
        return this.soundLoopMode;
    }

    public void setSoundLoopMode(SoundLoopMode mode) {
        if (mode != null) {
            this.soundLoopMode = mode;
        }
    }

    public int getSoundLoopAmount() {
        return this.soundLoopAmount;
    }

    public void setSoundLoopAmount(int amount) {
        this.soundLoopAmount = Math.max(1, Math.min(amount, 1000));
    }

    public boolean isFailsafeGUIEnabled() {
        return this.failsafeGUIEnabled;
    }

    public void setFailsafeGUIEnabled(boolean enabled) {
        this.failsafeGUIEnabled = enabled;
    }

    public boolean isBreakProtectionEnabled() {
        return this.breakProtectionEnabled;
    }

    public void setBreakProtectionEnabled(boolean enabled) {
        this.breakProtectionEnabled = enabled;
    }

    public boolean isInventoryFullFailsafeEnabled() {
        return this.inventoryFullFailsafeEnabled;
    }

    public void setInventoryFullFailsafeEnabled(boolean enabled) {
        this.inventoryFullFailsafeEnabled = enabled;
    }

    public boolean isItemSwapFailsafeEnabled() {
        return this.itemSwapFailsafeEnabled;
    }

    public void setItemSwapFailsafeEnabled(boolean enabled) {
        this.itemSwapFailsafeEnabled = enabled;
    }

    public boolean isMouseUngrabEnabled() {
        return this.mouseUngrabEnabled;
    }

    public void setMouseUngrabEnabled(boolean enabled) {
        this.mouseUngrabEnabled = enabled;
    }

    public boolean isMoblessTimeoutFailsafeEnabled() {
        return this.moblessTimeoutFailsafeEnabled;
    }

    public void setMoblessTimeoutFailsafeEnabled(boolean enabled) {
        this.moblessTimeoutFailsafeEnabled = enabled;
    }

    public boolean isTeleportFailsafeEnabled() {
        return this.teleportFailsafeEnabled;
    }

    public void setTeleportFailsafeEnabled(boolean enabled) {
        this.teleportFailsafeEnabled = enabled;
    }

    public boolean isHeadTurnFailsafeEnabled() {
        return this.headTurnFailsafeEnabled;
    }

    public void setHeadTurnFailsafeEnabled(boolean enabled) {
        this.headTurnFailsafeEnabled = enabled;
    }

    public int getMoblessTimeoutSeconds() {
        return this.moblessTimeoutSeconds;
    }

    public void setMoblessTimeoutSeconds(int seconds) {
        this.moblessTimeoutSeconds = Math.max(5, Math.min(seconds, 600));
        this.save();
    }

    public boolean isPetActivatorEnabled() {
        return this.petActivatorEnabled;
    }

    public void setPetActivatorEnabled(boolean enabled) {
        this.petActivatorEnabled = enabled;
        this.save();
    }

    public boolean isClickDelayEnabled() {
        return this.clickDelayEnabled;
    }

    public void setClickDelayEnabled(boolean enabled) {
        this.clickDelayEnabled = enabled;
        this.save();
    }

    public int getClickDelaySeconds() {
        return this.clickDelaySeconds;
    }

    public void setClickDelaySeconds(int seconds) {
        this.clickDelaySeconds = Math.max(0, Math.min(seconds, 10));
        this.save();
    }

    public HeadTurnMode getHeadTurnMode() {
        return this.headTurnMode;
    }

    public void setHeadTurnMode(HeadTurnMode mode) {
        if (mode != null) {
            this.headTurnMode = mode;
        }
        this.save();
    }

    public static enum SoundLoopMode {
        ONCE,
        SPECIFIED_AMOUNT,
        UNTIL_USER_ACTION;

    }

    public static enum HeadTurnMode {
        SOFT,
        STRICT,
        SUPER_STRICT;

    }
}

