/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.prefab.utilities.object.TransferPack;

public class TunnelFrequencyBuffer {
    public static final Codec<TunnelFrequencyBuffer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TransferPack.CODEC.fieldOf("energy").forGetter(TunnelFrequencyBuffer::getBufferedEnergy), (App)FluidStack.OPTIONAL_CODEC.fieldOf("fluid").forGetter(TunnelFrequencyBuffer::getBufferedFluid), (App)GasStack.CODEC.fieldOf("gas").forGetter(TunnelFrequencyBuffer::getBufferedGas), (App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(TunnelFrequencyBuffer::getBufferedItem)).apply((Applicative)instance, TunnelFrequencyBuffer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TunnelFrequencyBuffer> STREAM_CODEC = StreamCodec.composite((StreamCodec)TransferPack.STREAM_CODEC, TunnelFrequencyBuffer::getBufferedEnergy, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, TunnelFrequencyBuffer::getBufferedFluid, (StreamCodec)GasStack.STREAM_CODEC, TunnelFrequencyBuffer::getBufferedGas, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, TunnelFrequencyBuffer::getBufferedItem, TunnelFrequencyBuffer::new);
    public static final TunnelFrequencyBuffer EMPTY = new TunnelFrequencyBuffer(TransferPack.EMPTY, FluidStack.EMPTY, GasStack.EMPTY, ItemStack.EMPTY);
    public static final double MAX_JOULES_CAP = Double.MAX_VALUE;
    public static final int MAX_FLUID_CAP = Integer.MAX_VALUE;
    public static final int MAX_GAS_CAP = Integer.MAX_VALUE;
    public static final int MAX_ITEM_STACK_SIZE = 1000;
    private TransferPack energyBuffer = TransferPack.EMPTY;
    private FluidStack fluidBuffer = FluidStack.EMPTY;
    private GasStack gasBuffer = GasStack.EMPTY;
    private ItemStack itemBuffer = ItemStack.EMPTY;

    private TunnelFrequencyBuffer(TransferPack energy, FluidStack fluid, GasStack gas, ItemStack item) {
        this.energyBuffer = energy;
        this.fluidBuffer = fluid;
        this.gasBuffer = gas;
        this.itemBuffer = item;
    }

    public TunnelFrequencyBuffer() {
    }

    public TransferPack getBufferedEnergy() {
        return this.energyBuffer;
    }

    public FluidStack getBufferedFluid() {
        return this.fluidBuffer;
    }

    public GasStack getBufferedGas() {
        return this.gasBuffer;
    }

    public ItemStack getBufferedItem() {
        return this.itemBuffer;
    }

    public TransferPack addEnergy(boolean simulate, TransferPack addition) {
        if (addition.getJoules() <= 0.0) {
            return TransferPack.EMPTY;
        }
        if (this.energyBuffer.getVoltage() <= 0.0 && this.energyBuffer.getJoules() <= 0.0) {
            TransferPack check = addition;
            if (check.getJoules() - Double.MAX_VALUE > 0.0) {
                check = TransferPack.joulesVoltage((double)Double.MAX_VALUE, (double)addition.getVoltage());
            }
            if (!simulate) {
                this.energyBuffer = TransferPack.joulesVoltage((double)check.getJoules(), (double)check.getVoltage());
            }
            return check;
        }
        if (this.energyBuffer.getVoltage() != 0.0 && this.energyBuffer.getVoltage() != addition.getVoltage()) {
            return TransferPack.EMPTY;
        }
        double accepted = Math.min(Double.MAX_VALUE - this.energyBuffer.getJoules(), addition.getJoules());
        if (!simulate) {
            this.energyBuffer = TransferPack.joulesVoltage((double)(this.energyBuffer.getJoules() + accepted), (double)this.energyBuffer.getVoltage());
        }
        return TransferPack.joulesVoltage((double)accepted, (double)addition.getVoltage());
    }

    public TransferPack extractEnergy(boolean simulate, TransferPack extract) {
        if (this.energyBuffer.getJoules() <= 0.0 || this.energyBuffer.getVoltage() <= 0.0 || extract.getVoltage() <= 0.0 || extract.getJoules() <= 0.0 || this.energyBuffer.getVoltage() != extract.getVoltage()) {
            return TransferPack.EMPTY;
        }
        double taken = Math.min(extract.getJoules(), this.energyBuffer.getJoules());
        if (!simulate) {
            this.energyBuffer = taken >= this.energyBuffer.getJoules() ? TransferPack.EMPTY : TransferPack.joulesVoltage((double)(this.energyBuffer.getJoules() - taken), (double)this.energyBuffer.getVoltage());
        }
        return TransferPack.joulesVoltage((double)taken, (double)extract.getVoltage());
    }

    public FluidStack addFluid(IFluidHandler.FluidAction action, FluidStack addition) {
        if (addition.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fluidBuffer.isEmpty()) {
            FluidStack check = addition;
            if (check.getAmount() - Integer.MAX_VALUE > 0) {
                check = new FluidStack(addition.getFluid(), Integer.MAX_VALUE);
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                this.fluidBuffer = check.copy();
            }
            return check;
        }
        if (this.fluidBuffer.getAmount() != 0 && !this.fluidBuffer.getFluid().isSame(addition.getFluid())) {
            return FluidStack.EMPTY;
        }
        int accepted = Math.min(Integer.MAX_VALUE - this.fluidBuffer.getAmount(), addition.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluidBuffer = new FluidStack(this.fluidBuffer.getFluid(), this.fluidBuffer.getAmount() + accepted);
        }
        return new FluidStack(addition.getFluid(), accepted);
    }

    public FluidStack extractFluid(IFluidHandler.FluidAction action, FluidStack extract) {
        if (this.fluidBuffer.isEmpty() || extract.isEmpty() || !this.fluidBuffer.getFluid().isSame(extract.getFluid())) {
            return FluidStack.EMPTY;
        }
        int taken = Math.min(extract.getAmount(), this.fluidBuffer.getAmount());
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.fluidBuffer = taken >= this.fluidBuffer.getAmount() ? FluidStack.EMPTY : new FluidStack(this.fluidBuffer.getFluid(), this.fluidBuffer.getAmount() - taken);
        }
        return new FluidStack(extract.getFluid(), taken);
    }

    public GasStack addGas(GasAction action, GasStack addition) {
        if (addition.isEmpty()) {
            return GasStack.EMPTY;
        }
        if (this.gasBuffer.isEmpty()) {
            GasStack check = addition;
            if (check.getAmount() - Integer.MAX_VALUE > 0) {
                check = new GasStack(addition.getGas(), Integer.MAX_VALUE, addition.getTemperature(), addition.getPressure());
            }
            if (action == GasAction.EXECUTE) {
                this.gasBuffer = check.copy();
            }
            return check;
        }
        if (this.gasBuffer.getAmount() != 0 && !this.gasBuffer.getGas().equals((Object)addition.getGas())) {
            return GasStack.EMPTY;
        }
        if (this.gasBuffer.getTemperature() != addition.getTemperature() || this.gasBuffer.getPressure() != addition.getPressure()) {
            return GasStack.EMPTY;
        }
        int accepted = Math.min(Integer.MAX_VALUE - this.gasBuffer.getAmount(), addition.getAmount());
        if (action == GasAction.EXECUTE) {
            this.gasBuffer = new GasStack(this.gasBuffer.getGas(), this.gasBuffer.getAmount() + accepted, this.gasBuffer.getTemperature(), this.gasBuffer.getPressure());
        }
        return new GasStack(addition.getGas(), accepted, addition.getTemperature(), addition.getPressure());
    }

    public GasStack extractGas(GasAction action, GasStack extract) {
        if (this.gasBuffer.isEmpty() || extract.isEmpty() || !this.gasBuffer.getGas().equals((Object)extract.getGas()) || this.gasBuffer.getTemperature() != extract.getTemperature() || this.gasBuffer.getPressure() != extract.getPressure()) {
            return GasStack.EMPTY;
        }
        int taken = Math.min(extract.getAmount(), this.gasBuffer.getAmount());
        if (action == GasAction.EXECUTE) {
            this.gasBuffer = taken >= this.gasBuffer.getAmount() ? GasStack.EMPTY : new GasStack(this.gasBuffer.getGas(), this.gasBuffer.getAmount() - taken, this.gasBuffer.getTemperature(), this.gasBuffer.getPressure());
        }
        return new GasStack(extract.getGas(), taken, extract.getTemperature(), extract.getPressure());
    }

    public ItemStack addItem(boolean simulate, ItemStack addition) {
        if (addition.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.itemBuffer.isEmpty()) {
            ItemStack check = addition;
            if (check.getCount() - 1000 > 0) {
                check = addition.copy();
                check.setCount(1000);
            }
            if (!simulate) {
                this.itemBuffer = check.copy();
            }
            return check;
        }
        if (this.itemBuffer.getCount() > 0 && addition.getItem() != this.itemBuffer.getItem()) {
            return ItemStack.EMPTY;
        }
        int accepted = Math.min(1000 - this.itemBuffer.getCount(), addition.getCount());
        if (!simulate) {
            this.itemBuffer.setCount(accepted + this.itemBuffer.getCount());
        }
        ItemStack returned = addition.copy();
        returned.setCount(accepted);
        return returned;
    }

    public ItemStack extractItem(boolean simulate, ItemStack extract) {
        if (this.itemBuffer.isEmpty() || extract.isEmpty() || extract.getItem() != this.itemBuffer.getItem()) {
            return ItemStack.EMPTY;
        }
        int taken = Math.min(extract.getCount(), this.itemBuffer.getCount());
        if (!simulate) {
            if (taken >= this.itemBuffer.getCount()) {
                this.itemBuffer = ItemStack.EMPTY;
            } else {
                this.itemBuffer.setCount(taken);
            }
        }
        ItemStack returned = extract.copy();
        returned.setCount(taken);
        return returned;
    }
}

