/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.particle.smoke;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import nuclearscience.client.particle.smoke.ParticleOptionSmoke;

public class ParticleSmoke
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public ParticleSmoke(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleOptionSmoke options, SpriteSet set) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.friction = 0.96f;
        this.gravity = options.gravity;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = set;
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.rCol = options.r;
        this.gCol = options.g;
        this.bCol = options.b;
        this.quadSize = options.scale;
        this.lifetime = options.lifetime;
        this.setSpriteFromAge(this.sprites);
        this.hasPhysics = options.hasPhysics;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        super.tick();
        this.setSprite(this.sprites.get(this.level.getRandom()));
    }

    public static class Factory
    implements ParticleProvider<ParticleOptionSmoke>,
    ParticleEngine.SpriteParticleRegistration<ParticleOptionSmoke> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(ParticleOptionSmoke type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleSmoke(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }

        public ParticleProvider<ParticleOptionSmoke> create(SpriteSet sprites) {
            return new Factory(sprites);
        }
    }
}

