/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderFissionReactorCore
extends AbstractTileRenderer<TileFissionReactorCore> {
    public static final AABB FUEL_ROD_1 = new AABB(0.1875, 0.1125, 0.1875, 0.25, 0.75, 0.25);
    public static final AABB FUEL_ROD_2 = new AABB(0.75, 0.1125, 0.1875, 0.8125, 0.75, 0.25);
    public static final AABB FUEL_ROD_3 = new AABB(0.75, 0.1125, 0.75, 0.8125, 0.75, 0.8125);
    public static final AABB FUEL_ROD_4 = new AABB(0.1875, 0.1125, 0.75, 0.25, 0.75, 0.8125);
    public static final AABB TRITIUM_CELL = new AABB(0.4375, 0.1125, 0.4375, 0.5625, 0.75, 0.5625);
    public static final Color HIGH_ENRICH = new Color(75, 181, 0, 255);
    public static final Color LOW_ENRICH = new Color(40, 98, 0, 255);
    public static final Color SPENT = new Color(116, 147, 95, 255);
    public static final Color PLUTONIUM = new Color(227, 125, 11, 255);
    public static final Color DEUTERIUM = new Color(0, 144, 255, 255);
    public static final Color TRITIUM = new Color(255, 255, 0, 255);
    public static final boolean[] FACES = new boolean[]{false, false, true, true, true, true};

    public RenderFissionReactorCore(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileFissionReactorCore tile, float partialTicks, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrix.pushPose();
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        if (!inv.areInputsEmpty()) {
            List inputs = inv.getInputContents();
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = (ItemStack)inputs.get(i);
                if (stack.isEmpty()) continue;
                RenderFissionReactorCore.renderFuelCell(i, stack, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            if (!((ItemStack)inputs.get(4)).isEmpty()) {
                RenderFissionReactorCore.renderDeuteriumCell(DEUTERIUM, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
            } else if (!((ItemStack)inv.getOutputContents().get(0)).isEmpty()) {
                RenderFissionReactorCore.renderDeuteriumCell(TRITIUM, matrix, bufferIn, combinedLightIn, combinedOverlayIn);
            }
        }
        matrix.popPose();
    }

    private static void renderDeuteriumCell(Color color, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrix.pushPose();
        TextureAtlasSprite texture = NuclearScienceClientRegister.getSprite(NuclearScienceClientRegister.TEXTURE_FUELCELL);
        RenderingUtils.renderFilledBoxNoOverlay((PoseStack)matrix, (VertexConsumer)bufferIn.getBuffer(RenderType.SOLID), (AABB)TRITIUM_CELL, (float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat(), (float)texture.getU0(), (float)texture.getV0(), (float)texture.getU1(), (float)texture.getV1(), (int)combinedLightIn, (boolean[])FACES);
        matrix.popPose();
    }

    private static void renderFuelCell(int cellSlot, ItemStack stack, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite texture = NuclearScienceClientRegister.getSprite(NuclearScienceClientRegister.TEXTURE_FUELCELL);
        matrix.pushPose();
        Color color = RenderFissionReactorCore.getColorFromFuel(stack);
        AABB box = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        switch (cellSlot) {
            case 0: {
                box = FUEL_ROD_1;
                break;
            }
            case 1: {
                box = FUEL_ROD_2;
                break;
            }
            case 2: {
                box = FUEL_ROD_3;
                break;
            }
            case 3: {
                box = FUEL_ROD_4;
                break;
            }
        }
        RenderingUtils.renderFilledBoxNoOverlay((PoseStack)matrix, (VertexConsumer)bufferIn.getBuffer(RenderType.SOLID), (AABB)box, (float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat(), (float)texture.getU0(), (float)texture.getV0(), (float)texture.getU1(), (float)texture.getV1(), (int)combinedLightIn, (boolean[])FACES);
        matrix.popPose();
    }

    public static Color getColorFromFuel(ItemStack stack) {
        if (stack.is(NuclearScienceTags.Items.FUELROD_URANIUM_LOW_EN)) {
            return LOW_ENRICH;
        }
        if (stack.is(NuclearScienceTags.Items.FUELROD_URANIUM_HIGH_EN)) {
            return HIGH_ENRICH;
        }
        if (stack.is(NuclearScienceTags.Items.FUELROD_PLUTONIUM)) {
            return PLUTONIUM;
        }
        if (stack.is(NuclearScienceTags.Items.FUELROD_SPENT)) {
            return SPENT;
        }
        return Color.WHITE;
    }
}

