/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileMSInterface;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderMSInterface
extends AbstractTileRenderer<TileMSInterface> {
    private static final double MAX_DELTA = 0.625;

    public RenderMSInterface(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileMSInterface tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        Direction facing = tile.getFacing();
        int sign = 1;
        if (facing == Direction.WEST || facing == Direction.EAST) {
            sign = -1;
        }
        stack.mulPose(MathUtils.rotQuaternionDeg((float)0.0f, (float)(facing.toYRot() + (float)(sign * 90)), (float)0.0f));
        double insertion = (double)((Integer)tile.insertion.getValue()).intValue() / 100.0;
        stack.translate(0.625 * insertion, 0.0, 0.0);
        RenderingUtils.renderModel((BakedModel)this.getModel(NuclearScienceClientRegister.MODEL_MSCONTROLROD_ROD), (BlockEntity)tile, (RenderType)RenderType.solid(), (PoseStack)stack, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        stack.popPose();
    }
}

