/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import nuclearscience.common.tile.TileRadioactiveProcessor;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderRadioactiveProcessor
extends AbstractTileRenderer<TileRadioactiveProcessor> {
    private static final float DELTA_Y = 0.25f;

    public RenderRadioactiveProcessor(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileRadioactiveProcessor tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int overlay) {
        matrix.pushPose();
        Direction facing = tile.getFacing();
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler);
        VertexConsumer builder = buffer.getBuffer(Sheets.translucentCullBlockSheet());
        PropertyFluidTank input = multi.getInputTanks()[0];
        if (input.isEmpty()) {
            matrix.popPose();
            return;
        }
        AABB box = null;
        float maxY = 0.25f * ((float)input.getFluidAmount() / 5000.0f) + 0.4375f;
        switch (facing) {
            case NORTH: {
                box = new AABB(0.25, 0.4375, 0.03125, 0.75, (double)maxY, 0.0625);
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
            case SOUTH: {
                box = new AABB(0.25, 0.4375, 0.96875, 0.75, (double)maxY, 0.9375);
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
            case EAST: {
                box = new AABB(0.96875, 0.4375, 0.25, 0.9375, (double)maxY, 0.75);
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
            case WEST: {
                box = new AABB(0.03125, 0.4375, 0.25, 0.0625, (double)maxY, 0.75);
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                break;
            }
        }
        matrix.popPose();
    }
}

