/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.ContainerMonitorModule;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileMonitorModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFissionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFusionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileMSInterface;
import nuclearscience.common.tile.reactor.moltensalt.TileFreezePlug;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.component.types.ScreenComponentCustomRender;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenMonitorModule
extends GenericInterfaceBoundScreen<ContainerMonitorModule> {
    private boolean hidden = false;
    private static final ITexture EMPTY_FUEL = NuclearIconTypes.FUEL_CELL_DARK;

    public ScreenMonitorModule(ContainerMonitorModule container, Inventory inv, Component title) {
        super(container, inv, title, true, false);
        for (int i = 0; i < ((ContainerMonitorModule)this.getMenu()).slots.size(); ++i) {
            ((SlotGeneric)((ContainerMonitorModule)this.getMenu()).slots.get(i)).setActive(false);
        }
        this.addComponent((AbstractScreenComponent)new ScreenComponentCustomRender(0, 0, graphics -> {
            if (this.hidden) {
                return;
            }
            TileMonitorModule tile = (TileMonitorModule)((ContainerMonitorModule)this.menu).getSafeHost();
            if (tile == null) {
                return;
            }
            GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)tile.interfaceType.getValue()];
            Font font = this.getFontRenderer();
            int guiWidth = (int)this.getGuiWidth();
            int guiHeight = (int)this.getGuiHeight();
            graphics.fill(guiWidth + 17, guiHeight + 17, guiWidth + 159, guiHeight + 149, new Color(112, 112, 112, 255).color());
            if (!((Boolean)tile.linked.getValue()).booleanValue() || type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)tile.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
                graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                return;
            }
            BlockEntity blockEntity = tile.getLevel().getBlockEntity((BlockPos)tile.interfaceLocation.getValue());
            switch (type) {
                case FISSION: {
                    if (!(blockEntity instanceof TileFissionInterface)) {
                        graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        return;
                    }
                    TileFissionInterface fissionInterface = (TileFissionInterface)blockEntity;
                    if (fissionInterface.reactor == null || !fissionInterface.reactor.valid() || !(fissionInterface.reactor.getSafe() instanceof TileFissionReactorCore)) {
                        graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        return;
                    }
                    TileFissionReactorCore fissionCore = (TileFissionReactorCore)((Object)((Object)fissionInterface.reactor.getSafe()));
                    graphics.renderItem(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)TileFissionReactorCore.getActualTemp((Double)fissionCore.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).withStyle(ChatFormatting.GOLD)), guiWidth + 20, guiHeight + 45, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.fuel", new Object[0]), guiWidth + 20, guiHeight + 65, Color.TEXT_GRAY.color(), false);
                    ComponentInventory inventory = (ComponentInventory)fissionCore.getComponent(IComponentType.Inventory);
                    List fuels = inventory.getItems().subList(0, 4);
                    int i = 0;
                    int empty = 0;
                    for (ItemStack item : fuels) {
                        if (item.isEmpty()) {
                            graphics.blit(EMPTY_FUEL.getLocation(), guiWidth + 20 + i * 20 + 2, guiHeight + 75 + 2, (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), EMPTY_FUEL.textureWidth(), EMPTY_FUEL.textureHeight(), EMPTY_FUEL.imageWidth(), EMPTY_FUEL.imageHeight());
                            ++empty;
                        } else {
                            graphics.renderItem(item, guiWidth + 20 + i * 20, guiHeight + 75);
                            graphics.renderItemDecorations(font, item, guiWidth + 20 + i * 20, guiHeight + 75);
                        }
                        ++i;
                    }
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.other", new Object[0]), guiWidth + 110, guiHeight + 65, Color.TEXT_GRAY.color(), false);
                    ItemStack deuterium = inventory.getItem(4);
                    if (deuterium.isEmpty()) {
                        graphics.blit(EMPTY_FUEL.getLocation(), guiWidth + 110 + 2, guiHeight + 75 + 2, (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), EMPTY_FUEL.textureWidth(), EMPTY_FUEL.textureHeight(), EMPTY_FUEL.imageWidth(), EMPTY_FUEL.imageHeight());
                    } else {
                        graphics.renderItem(deuterium, guiWidth + 110, guiHeight + 75);
                        graphics.renderItemDecorations(font, deuterium, guiWidth + 110, guiHeight + 75);
                    }
                    ItemStack tritium = (ItemStack)inventory.getOutputContents().get(0);
                    if (tritium.isEmpty()) {
                        graphics.blit(EMPTY_FUEL.getLocation(), guiWidth + 130 + 2, guiHeight + 75 + 2, (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), EMPTY_FUEL.textureWidth(), EMPTY_FUEL.textureHeight(), EMPTY_FUEL.imageWidth(), EMPTY_FUEL.imageHeight());
                    } else {
                        graphics.renderItem(tritium, guiWidth + 130, guiHeight + 75);
                        graphics.renderItemDecorations(font, tritium, guiWidth + 130, guiHeight + 75);
                    }
                    MutableComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).withStyle(ChatFormatting.GREEN);
                    if (empty == 4) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnofuel", new Object[0]).withStyle(ChatFormatting.YELLOW);
                    } else if ((Double)fissionCore.temperature.getValue() > 5611.0) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusoverheat", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                    }
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.status", status), guiWidth + 20, guiHeight + 105, Color.TEXT_GRAY.color(), false);
                    break;
                }
                case MS: {
                    if (!(blockEntity instanceof TileMSInterface)) {
                        graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        return;
                    }
                    TileMSInterface msInterface = (TileMSInterface)blockEntity;
                    if (msInterface.reactor == null || !msInterface.reactor.valid() || !(msInterface.reactor.getSafe() instanceof TileMSReactorCore)) {
                        graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        return;
                    }
                    TileMSReactorCore msCore = (TileMSReactorCore)((Object)((Object)msInterface.reactor.getSafe()));
                    graphics.renderItem(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)((Double)msCore.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).withStyle(ChatFormatting.GOLD)), guiWidth + 20, guiHeight + 45, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.fuel", new Object[0]), guiWidth + 20, guiHeight + 65, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Double)msCore.currentFuel.getValue() / 1000.0), (IDisplayUnit)DisplayUnits.BUCKETS), (Component)ChatFormatter.getChatDisplayShort((double)1.0, (IDisplayUnit)DisplayUnits.BUCKETS)), guiWidth + 30, guiHeight + 75, Color.WHITE.color(), false);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.waste", new Object[0]), guiWidth + 20, guiHeight + 90, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Double)msCore.currentWaste.getValue() / 1000.0), (IDisplayUnit)DisplayUnits.BUCKETS), (Component)ChatFormatter.getChatDisplayShort((double)1.0, (IDisplayUnit)DisplayUnits.BUCKETS)), guiWidth + 30, guiHeight + 100, Color.WHITE.color(), false);
                    MutableComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).withStyle(ChatFormatting.GREEN);
                    if (!(msCore.clientPlugCache.getSafe() instanceof TileFreezePlug)) {
                        status = NuclearTextUtils.gui("msreactor.status.nofreezeplug", new Object[0]).withStyle(ChatFormatting.RED);
                    } else {
                        TileFreezePlug plug;
                        Object patt0$temp = msCore.clientPlugCache.getSafe();
                        if (patt0$temp instanceof TileFreezePlug && !(plug = (TileFreezePlug)((Object)((Object)patt0$temp))).isFrozen()) {
                            status = NuclearTextUtils.gui("msreactor.warning.freezeoff", new Object[0]).withStyle(ChatFormatting.YELLOW);
                        } else if (((Boolean)msCore.wasteIsFull.getValue()).booleanValue()) {
                            status = NuclearTextUtils.gui("msreactor.status.wastefull", new Object[0]).withStyle(ChatFormatting.YELLOW);
                        } else if ((Double)msCore.temperature.getValue() > 1000.0) {
                            status = NuclearTextUtils.gui("logisticsnetwork.statusoverheat", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                        }
                    }
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.status", status), guiWidth + 20, guiHeight + 115, Color.TEXT_GRAY.color(), false);
                    break;
                }
                case FUSION: {
                    if (!(blockEntity instanceof TileFusionInterface)) {
                        graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        return;
                    }
                    TileFusionInterface fusionInterface = (TileFusionInterface)blockEntity;
                    if (fusionInterface.reactor == null || !fusionInterface.reactor.valid() || !(fusionInterface.reactor.getSafe() instanceof TileFusionReactorCore)) {
                        graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        return;
                    }
                    TileFusionReactorCore fusionCore = (TileFusionReactorCore)((Object)((Object)fusionInterface.reactor.getSafe()));
                    ComponentElectrodynamic electro = (ComponentElectrodynamic)fusionCore.getComponent(IComponentType.Electrodynamic);
                    graphics.renderItem(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.deuterium", new Object[0]), guiWidth + 20, guiHeight + 45, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)VoltaicTextUtils.ratio((Component)Component.literal((String)String.valueOf(fusionCore.deuterium.getValue())), (Component)Component.literal((String)String.valueOf(NuclearConfig.INSTANCE.FUSIONREACTOR_MAXSTORAGE.get()))), guiWidth + 30, guiHeight + 55, Color.WHITE.color(), false);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.tritium", new Object[0]), guiWidth + 20, guiHeight + 70, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)VoltaicTextUtils.ratio((Component)Component.literal((String)String.valueOf(fusionCore.tritium.getValue())), (Component)Component.literal((String)String.valueOf(NuclearConfig.INSTANCE.FUSIONREACTOR_MAXSTORAGE.get()))), guiWidth + 30, guiHeight + 80, Color.WHITE.color(), false);
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.power", new Object[0]), guiWidth + 20, guiHeight + 95, Color.TEXT_GRAY.color(), false);
                    graphics.drawString(font, (Component)ChatFormatter.getChatDisplayShort((double)(Math.min(1.0, electro.getJoulesStored() / (Double)NuclearConfig.INSTANCE.FUSIONREACTOR_USAGE_PER_TICK.get()) * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE), guiWidth + 30, guiHeight + 105, Color.WHITE.color(), false);
                    MutableComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).withStyle(ChatFormatting.GREEN);
                    if ((Integer)fusionCore.tritium.getValue() < 1 || (Integer)fusionCore.deuterium.getValue() < 1) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnofuel", new Object[0]).withStyle(ChatFormatting.RED);
                    } else if (electro.getJoulesStored() < (Double)NuclearConfig.INSTANCE.FUSIONREACTOR_USAGE_PER_TICK.get()) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnopower", new Object[0]).withStyle(ChatFormatting.YELLOW);
                    }
                    graphics.drawString(font, (Component)NuclearTextUtils.gui("logisticsnetwork.status", status), guiWidth + 20, guiHeight + 120, Color.TEXT_GRAY.color(), false);
                    break;
                }
            }
        }));
    }

    @Override
    public void updateNonSelectorVisibility(boolean visible) {
        this.hidden = !visible;
    }
}

