/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperEditFrequency;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperIOEditor;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperNewFrequency;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperQuantumTunnelFrequencies;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.GasStack;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.object.TransferPack;

public class ScreenQuantumTunnel
extends GenericScreen<ContainerQuantumTunnel> {
    public WrapperQuantumTunnelFrequencies frequencyWrapper;
    public WrapperIOEditor ioWrapper;
    public WrapperNewFrequency newFrequencyWrapper;
    public WrapperEditFrequency editFrequencyWrapper;
    public ScreenComponentVerticalSlider slider;

    public ScreenQuantumTunnel(ContainerQuantumTunnel container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.imageHeight += 35;
        this.frequencyWrapper = new WrapperQuantumTunnelFrequencies(this, 0, 0);
        this.slider = new ScreenComponentVerticalSlider(5, 64, 125).setClickConsumer(this.frequencyWrapper.getSliderClickedConsumer()).setDragConsumer(this.frequencyWrapper.getSliderDraggedConsumer());
        this.addComponent((AbstractScreenComponent)this.slider);
        this.ioWrapper = new WrapperIOEditor(this, -25, 28, 80, 28, 8, 23);
        this.newFrequencyWrapper = new WrapperNewFrequency(this, -25, 2, 0, 15);
        this.editFrequencyWrapper = new WrapperEditFrequency(this, 0, 10);
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)NuclearIconTypes.BUFFER, () -> {
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)this.getMenu()).getSafeHost();
            if (tile == null) {
                return Collections.emptyList();
            }
            TunnelFrequencyBuffer buffer = tile.clientBuffer;
            ArrayList<FormattedCharSequence> info = new ArrayList<FormattedCharSequence>();
            info.add(NuclearTextUtils.tooltip("quantumtunnel.buffer", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}).getVisualOrderText());
            ItemStack item = buffer.getBufferedItem();
            info.add(Component.translatable((String)item.getDescriptionId()).getVisualOrderText());
            info.add(Component.literal((String)(" " + item.getCount())).withStyle(ChatFormatting.GRAY).getVisualOrderText());
            FluidStack fluid = buffer.getBufferedFluid();
            info.add(Component.translatable((String)fluid.getTranslationKey()).getVisualOrderText());
            info.add(Component.literal((String)" ").append((Component)ChatFormatter.formatFluidMilibuckets((double)fluid.getAmount()).withStyle(ChatFormatting.GRAY)).getVisualOrderText());
            GasStack gas = buffer.getBufferedGas();
            info.add(gas.getGas().getDescription().getVisualOrderText());
            info.add(Component.literal((String)" ").append((Component)ChatFormatter.formatFluidMilibuckets((double)gas.getAmount()).withStyle(ChatFormatting.GRAY)).getVisualOrderText());
            info.add(Component.literal((String)" ").append((Component)ChatFormatter.getChatDisplayShort((double)gas.getTemperature(), (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN).withStyle(ChatFormatting.GRAY)).getVisualOrderText());
            info.add(Component.literal((String)" ").append((Component)ChatFormatter.getChatDisplayShort((double)gas.getPressure(), (IDisplayUnit)DisplayUnits.PRESSURE_ATM).withStyle(ChatFormatting.GRAY)).getVisualOrderText());
            TransferPack energy = buffer.getBufferedEnergy();
            info.add(ChatFormatter.getChatDisplayShort((double)energy.getJoules(), (IDisplayUnit)DisplayUnits.JOULES).getVisualOrderText());
            info.add(Component.literal((String)" ").append((Component)ChatFormatter.getChatDisplayShort((double)energy.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).withStyle(ChatFormatting.GRAY)).getVisualOrderText());
            return info;
        }, -25, 54));
    }

    protected void containerTick() {
        super.containerTick();
        this.frequencyWrapper.tick();
    }

    protected void initializeComponents() {
        super.initializeComponents();
        this.playerInvLabel.setVisible(false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.frequencyWrapper != null) {
            if (scrollY > 0.0) {
                this.frequencyWrapper.handleMouseScroll(-1);
            } else if (scrollY < 0.0) {
                this.frequencyWrapper.handleMouseScroll(1);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)pKeyCode, (int)pScanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) && this.newFrequencyWrapper.nameEditBox.isFocused()) {
            return false;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.slider.isVisible()) {
            return this.slider.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }
}

