/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentProgress;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;
import voltaic.prefab.utilities.object.TransferPack;

public class ScreenRadioisotopeGenerator
extends GenericScreen<ContainerRadioisotopeGenerator> {
    public ScreenRadioisotopeGenerator(ContainerRadioisotopeGenerator container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.addComponent((AbstractScreenComponent)new ScreenComponentProgress(ScreenComponentProgress.ProgressBars.COUNTDOWN_FLAME, () -> {
            ItemStack in = container.getSlot(0).getItem();
            RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.getItem());
            double currentOutput = (double)in.getCount() * (Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER.get() * rad.amount();
            if (currentOutput > 0.0) {
                return 1.0;
            }
            return 0.0;
        }, 25, 24));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getEnergyInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            ItemStack in = ((ContainerRadioisotopeGenerator)this.menu).getSlot(0).getItem();
            RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.getItem());
            double currentOutput = (double)in.getCount() * (Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER.get() * rad.amount();
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / (Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get()), (double)((Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get()));
            graphics.drawString(this.font, (Component)NuclearTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)transfer.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)), this.inventoryLabelX + 60, this.inventoryLabelY - 48, Color.TEXT_GRAY.color(), false);
            graphics.drawString(this.font, (Component)NuclearTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)transfer.getWatts(), (IDisplayUnit)DisplayUnits.WATT)), this.inventoryLabelX + 60, this.inventoryLabelY - 35, Color.TEXT_GRAY.color(), false);
            graphics.drawString(this.font, (Component)NuclearTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)transfer.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE)), this.inventoryLabelX + 60, this.inventoryLabelY - 22, Color.TEXT_GRAY.color(), false);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
    }

    private List<? extends FormattedCharSequence> getEnergyInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        ItemStack in = ((ContainerRadioisotopeGenerator)this.menu).getSlot(0).getItem();
        RadioactiveObject rad = RadioactiveItemRegister.getValue((Item)in.getItem());
        double currentOutput = (double)in.getCount() * (Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER.get() * rad.amount();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / (Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get()), (double)((Double)NuclearConfig.INSTANCE.RADIOISOTOPEGENERATOR_VOLTAGE.get()));
        list.add(NuclearTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort((double)transfer.getAmps(), (IDisplayUnit)DisplayUnits.AMPERE)).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        list.add(NuclearTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort((double)transfer.getWatts(), (IDisplayUnit)DisplayUnits.WATT).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        list.add(NuclearTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort((double)transfer.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
        return list;
    }
}

