/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import nuclearscience.common.inventory.container.ContainerTeleporter;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tile.TileTeleporter;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.math.Color;
import voltaic.registers.VoltaicDataComponentTypes;

public class ScreenTeleporter
extends GenericScreen<ContainerTeleporter> {
    private final ScreenComponentEditBox xBox;
    private final ScreenComponentEditBox yBox;
    private final ScreenComponentEditBox zBox;
    private boolean needsUpdate = true;

    public ScreenTeleporter(ContainerTeleporter container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.imageHeight += 50;
        this.inventoryLabelY += 50;
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 20, 10, Color.TEXT_GRAY, () -> {
            TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.getMenu()).getSafeHost();
            if (tile == null) {
                return Component.empty();
            }
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)tile.dimension.getValue()));
            if (ElectroTextUtils.dimensionExists((ResourceKey)dimension)) {
                return ElectroTextUtils.dimension((ResourceKey)dimension, (Object[])new Object[0]);
            }
            return Component.literal((String)dimension.location().getPath());
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 33, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("teleporter.x", new Object[0])));
        this.xBox = new ScreenComponentEditBox(40, 30, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateX).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.xBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 49, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("teleporter.y", new Object[0])));
        this.yBox = new ScreenComponentEditBox(40, 46, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateY).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.yBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 65, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("teleporter.z", new Object[0])));
        this.zBox = new ScreenComponentEditBox(40, 62, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateZ).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.zBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(50, 78, 100, 20).setOnPress(button -> {
            TileTeleporter tile = (TileTeleporter)container.getSafeHost();
            if (tile == null) {
                return;
            }
            ItemStack input = ((ComponentInventory)tile.getComponent(IComponentType.Inventory)).getItem(0);
            if (input.isEmpty() || !input.has((Supplier)VoltaicDataComponentTypes.BLOCK_POS)) {
                return;
            }
            tile.destination.setValue(input.get((Supplier)VoltaicDataComponentTypes.BLOCK_POS));
            if (input.has((Supplier)VoltaicDataComponentTypes.RESOURCE_LOCATION)) {
                tile.dimension.setValue(input.get((Supplier)VoltaicDataComponentTypes.RESOURCE_LOCATION));
            }
        }).setLabel((Component)NuclearTextUtils.gui("teleporter.import", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(30, 100, 120, 20).setOnPress(button -> {
            TileTeleporter tile = (TileTeleporter)container.getSafeHost();
            if (tile == null) {
                return;
            }
            tile.destination.setValue((Object)tile.getBlockPos());
            tile.dimension.setValue((Object)Level.OVERWORLD.location());
            this.xBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost()).destination.getValue()).getX());
            this.yBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost()).destination.getValue()).getY());
            this.zBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost()).destination.getValue()).getZ());
        }).setLabel((Component)NuclearTextUtils.gui("teleporter.reset", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2).wattage((Double)NuclearConfig.INSTANCE.TELEPORTER_USAGE_PER_TELEPORT.get() / 20.0));
        this.xBox.setFocus(false);
        this.yBox.setFocus(false);
        this.zBox.setFocus(false);
    }

    private void updateX(String val) {
        this.xBox.setFocus(true);
        this.yBox.setFocus(false);
        this.zBox.setFocus(false);
        this.handleX(val);
    }

    private void updateY(String val) {
        this.xBox.setFocus(false);
        this.yBox.setFocus(true);
        this.zBox.setFocus(false);
        this.handleY(val);
    }

    private void updateZ(String val) {
        this.xBox.setFocus(false);
        this.yBox.setFocus(false);
        this.zBox.setFocus(true);
        this.handleZ(val);
    }

    private void handleX(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        Integer x = 0;
        try {
            x = Integer.parseInt(this.xBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(x.intValue(), dest.getY(), dest.getZ()));
    }

    private void handleY(String out) {
        if (out.isEmpty()) {
            return;
        }
        Integer y = 0;
        try {
            y = Integer.parseInt(this.yBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(dest.getX(), y.intValue(), dest.getZ()));
    }

    private void handleZ(String out) {
        if (out.isEmpty()) {
            return;
        }
        Integer z = 0;
        try {
            z = Integer.parseInt(this.zBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(dest.getX(), dest.getY(), z.intValue()));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate && ((ContainerTeleporter)this.menu).getSafeHost() != null) {
            this.needsUpdate = false;
            this.xBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost()).destination.getValue()).getX());
            this.yBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost()).destination.getValue()).getY());
            this.zBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.menu).getSafeHost()).destination.getValue()).getZ());
        }
    }
}

