/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nuclearscience.common.tile.TileTurbine;
import voltaic.prefab.block.GenericEntityBlockWaterloggable;

public class BlockTurbine
extends GenericEntityBlockWaterloggable {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.25, (double)2.5, (double)6.0, (double)14.75, (double)13.5, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)2.5, (double)1.25, (double)10.0, (double)13.5, (double)14.75), Block.box((double)2.0, (double)2.5, (double)4.0, (double)14.0, (double)13.5, (double)12.0), Block.box((double)4.0, (double)2.5, (double)2.0, (double)12.0, (double)13.5, (double)14.0), Block.box((double)3.0, (double)2.5, (double)3.0, (double)13.0, (double)13.5, (double)13.0), Block.box((double)4.65, (double)0.75, (double)4.65, (double)11.35, (double)2.5, (double)11.35), Block.box((double)4.3, (double)13.5, (double)4.3, (double)11.7, (double)15.0, (double)11.7), Block.box((double)5.7, (double)15.0, (double)5.7, (double)10.3, (double)16.0, (double)10.3)});
    public static final BooleanProperty RENDER = BooleanProperty.create((String)"render");

    public BlockTurbine() {
        super(Blocks.IRON_BLOCK.properties().strength(3.5f).sound(SoundType.METAL).requiresCorrectToolForDrops().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)RENDER, (Comparable)Boolean.valueOf(true)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileTurbine(pos, state);
    }

    public void onRotate(ItemStack stack, BlockPos pos, Player player) {
        super.onRotate(stack, pos, player);
        if (player.level().isClientSide()) {
            return;
        }
        TileTurbine turbine = (TileTurbine)player.level().getBlockEntity(pos);
        if (turbine != null) {
            if (((Boolean)turbine.isCore.getValue()).booleanValue()) {
                turbine.deconstructStructure();
            } else {
                turbine.constructStructure();
            }
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        if (!((Boolean)state.getValue((Property)RENDER)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return super.getRenderShape(state);
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)RENDER, (Comparable)Boolean.valueOf(true));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{RENDER});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)RENDER)).booleanValue()) {
            return SHAPE;
        }
        return Shapes.block();
    }
}

