/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import nuclearscience.common.block.states.NuclearScienceBlockStates;
import nuclearscience.common.block.states.facing.FacingDirection;
import nuclearscience.common.settings.NuclearConfig;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileParticleInjector;
import nuclearscience.prefab.sound.SoundBarrierMethods;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceEntities;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.Location;

public class EntityParticle
extends Entity {
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TICKS_ALIVE = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> SOURCE = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Boolean> PASSED_THROUGH_GATEWAY = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PASSED_THROUGH_SWITCH = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Direction> SWITCH_DIRECTION = SynchedEntityData.defineId(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static final float STARTING_SPEED = 0.02f;
    public static final float STRAIGHT_SPEED_INCREMENT = 0.0033333332f;
    public static final float TURN_SPEED_PENALTY = 0.9f;
    public static final float INVERT_SPEED_INCREMENT = -0.02f;
    public static final float MAX_SPEED = 2.0f;
    public static final float MIN_COLLISION_SPEED = 1.0f;
    private Direction facingDirection = Direction.UP;
    private Direction switchDirection = Direction.UP;
    public float speed = 0.02f;
    public BlockPos source = BlockEntityUtils.OUT_OF_REACH;
    public boolean passedThroughGate = false;
    private int ticksAlive = 0;
    private boolean passedThroughSwitch = false;
    private boolean firstTick = true;

    public EntityParticle(EntityType<?> entityTypeIn, Level worldIn) {
        super((EntityType)NuclearScienceEntities.ENTITY_PARTICLE.get(), worldIn);
    }

    public EntityParticle(Direction direction, Level worldIn, Location startPos, BlockPos ownerPos) {
        this((EntityType)NuclearScienceEntities.ENTITY_PARTICLE.get(), worldIn);
        this.setPos(new Vec3(startPos.x(), startPos.y(), startPos.z()));
        this.facingDirection = direction;
        this.noCulling = true;
        this.source = ownerPos;
        if (worldIn.isClientSide) {
            EntityParticle.setViewScale((double)4.0);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        if (this.facingDirection == null) {
            this.facingDirection = Direction.UP;
        }
        if (this.source == null) {
            this.source = BlockEntityUtils.OUT_OF_REACH;
        }
        if (this.switchDirection == null) {
            this.switchDirection = Direction.UP;
        }
        builder.define(DIRECTION, (Object)this.facingDirection);
        builder.define(SPEED, (Object)Float.valueOf(this.speed));
        builder.define(TICKS_ALIVE, (Object)this.ticksAlive);
        builder.define(SOURCE, (Object)this.source);
        builder.define(PASSED_THROUGH_GATEWAY, (Object)this.passedThroughGate);
        builder.define(PASSED_THROUGH_SWITCH, (Object)this.passedThroughSwitch);
        builder.define(SWITCH_DIRECTION, (Object)this.switchDirection);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        boolean isServerside;
        Level level = this.level();
        boolean isClientside = level.isClientSide();
        boolean bl = isServerside = !isClientside;
        if (isServerside) {
            if (this.facingDirection == null) {
                this.facingDirection = Direction.UP;
            }
            this.entityData.set(DIRECTION, (Object)this.facingDirection);
            this.entityData.set(SPEED, (Object)Float.valueOf(this.speed));
            this.entityData.set(TICKS_ALIVE, (Object)this.ticksAlive);
            this.entityData.set(SOURCE, (Object)this.source);
            this.entityData.set(PASSED_THROUGH_GATEWAY, (Object)this.passedThroughGate);
            this.entityData.set(PASSED_THROUGH_SWITCH, (Object)this.passedThroughSwitch);
            this.entityData.set(SWITCH_DIRECTION, (Object)this.switchDirection);
            RadiationSystem.addRadiationSource((Level)level, (SimpleRadiationSource)new SimpleRadiationSource(1000.0, 1.0, 2, true, 0, this.blockPosition(), false, false));
        } else {
            this.facingDirection = (Direction)this.entityData.get(DIRECTION);
            this.speed = ((Float)this.entityData.get(SPEED)).floatValue();
            this.ticksAlive = (Integer)this.entityData.get(TICKS_ALIVE);
            this.source = (BlockPos)this.entityData.get(SOURCE);
            this.passedThroughGate = (Boolean)this.entityData.get(PASSED_THROUGH_GATEWAY);
            this.passedThroughSwitch = (Boolean)this.entityData.get(PASSED_THROUGH_SWITCH);
            this.switchDirection = (Direction)this.entityData.get(SWITCH_DIRECTION);
        }
        if (isServerside) {
            ++this.ticksAlive;
        }
        if (this.ticksAlive > (Integer)NuclearConfig.INSTANCE.PARTICLE_SURVIVAL_TICKS.get()) {
            if (!isServerside) return;
            this.removeAfterChangingDimensions();
            level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.speed, Level.ExplosionInteraction.BLOCK);
            return;
        }
        if (this.facingDirection == null) return;
        if (this.facingDirection == Direction.UP) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.source);
        if (!(blockEntity instanceof TileParticleInjector)) {
            if (!isServerside) return;
            this.remove(Entity.RemovalReason.DISCARDED);
            level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.speed, Level.ExplosionInteraction.BLOCK);
            return;
        }
        TileParticleInjector injector = (TileParticleInjector)blockEntity;
        injector.addParticle(this);
        if (injector.handleCollision()) {
            return;
        }
        if (this.facingDirection == null) return;
        if (this.facingDirection == Direction.UP) return;
        if (this.facingDirection == Direction.DOWN) {
            return;
        }
        if (this.firstTick && isClientside) {
            this.firstTick = false;
            SoundBarrierMethods.playParticleSound(this);
        }
        int i = 0;
        int checks = (int)(Math.ceil(this.speed) * 2.0);
        float localSpeed = this.speed / (float)checks;
        while (i < checks) {
            Vec3 proposedMove;
            block59: {
                Direction nextDir;
                Direction oldDir;
                BlockState proposedMoveState;
                boolean startOfLoopStateIsBooster;
                BlockState startOfLoopState;
                block58: {
                    BlockPos proposedMoveBlockPos;
                    block54: {
                        block53: {
                            Direction clockwise;
                            Direction otherSwitchDirection;
                            block55: {
                                block56: {
                                    Direction counterClockwise;
                                    block57: {
                                        ++i;
                                        startOfLoopState = level.getBlockState(this.blockPosition());
                                        startOfLoopStateIsBooster = this.isBooster(startOfLoopState);
                                        boolean startofLoopStateIsDiode = this.isDiode(startOfLoopState);
                                        proposedMove = new Vec3(this.getX() + (double)((float)this.facingDirection.getStepX() * localSpeed), this.getY(), this.getZ() + (double)((float)this.facingDirection.getStepZ() * localSpeed));
                                        if (startOfLoopStateIsBooster) {
                                            Direction boosterFacing = ((Direction)startOfLoopState.getValue((Property)VoltaicBlockStates.FACING)).getOpposite();
                                            FacingDirection boosterOrientation = (FacingDirection)((Object)startOfLoopState.getValue((Property)NuclearScienceBlockStates.FACINGDIRECTION));
                                            if (boosterOrientation == FacingDirection.RIGHT) {
                                                boosterFacing = boosterFacing.getClockWise();
                                            } else if (boosterOrientation == FacingDirection.LEFT) {
                                                boosterFacing = boosterFacing.getCounterClockWise();
                                            }
                                            if (boosterFacing == this.facingDirection) {
                                                this.setSpeed(this.speed += 0.0033333332f);
                                            } else if (boosterFacing == this.facingDirection.getOpposite()) {
                                                this.setSpeed(this.speed += -0.02f);
                                            } else {
                                                this.setSpeed(this.speed *= 0.9f);
                                                this.facingDirection = boosterFacing;
                                                BlockPos floor = this.blockPosition();
                                                proposedMove = new Vec3((double)floor.getX() + 0.5, (double)floor.getY() + 0.5, (double)floor.getZ() + 0.5);
                                            }
                                        }
                                        if (this.speed < 0.0f) {
                                            this.setSpeed(this.speed *= -1.0f);
                                            this.facingDirection = this.facingDirection.getOpposite();
                                        }
                                        proposedMoveBlockPos = new BlockPos((int)Math.floor(proposedMove.x()), (int)Math.floor(proposedMove.y()), (int)Math.floor(proposedMove.z()));
                                        if (!startOfLoopStateIsBooster && !startofLoopStateIsDiode || this.passedThroughSwitch || !this.isSwitch(level.getBlockState(proposedMoveBlockPos))) break block54;
                                        if (!injector.particles[0].getUUID().equals(this.getUUID())) break block55;
                                        if (injector.particles[1] == null || !injector.particles[1].passedThroughSwitch) break block56;
                                        otherSwitchDirection = injector.particles[1].switchDirection;
                                        clockwise = this.facingDirection.getClockWise();
                                        counterClockwise = this.facingDirection.getCounterClockWise();
                                        if (this.facingDirection == otherSwitchDirection || !level.getBlockState(proposedMoveBlockPos.relative(this.facingDirection)).isAir()) break block57;
                                        this.switchDirection = this.facingDirection;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    }
                                    if (clockwise != otherSwitchDirection && level.getBlockState(proposedMoveBlockPos.relative(clockwise)).isAir()) {
                                        this.switchDirection = clockwise;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    } else if (counterClockwise != otherSwitchDirection && level.getBlockState(proposedMoveBlockPos.relative(counterClockwise)).isAir()) {
                                        this.switchDirection = counterClockwise;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    } else {
                                        if (!isServerside) return;
                                        level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                                        this.removeAfterChangingDimensions();
                                        return;
                                    }
                                }
                                Direction clockwise2 = this.facingDirection.getClockWise();
                                Direction counterClockwise = this.facingDirection.getCounterClockWise();
                                if (level.getBlockState(proposedMoveBlockPos.relative(this.facingDirection)).isAir()) {
                                    this.switchDirection = this.facingDirection;
                                    this.passedThroughSwitch = true;
                                    break block53;
                                } else if (level.getBlockState(proposedMoveBlockPos.relative(clockwise2)).isAir()) {
                                    this.switchDirection = clockwise2;
                                    this.passedThroughSwitch = true;
                                    break block53;
                                } else {
                                    if (!level.getBlockState(proposedMoveBlockPos.relative(counterClockwise)).isAir()) {
                                        if (!isServerside) return;
                                        level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                                        this.removeAfterChangingDimensions();
                                        return;
                                    }
                                    this.switchDirection = counterClockwise;
                                    this.passedThroughSwitch = true;
                                }
                                break block53;
                            }
                            if (!injector.particles[1].getUUID().equals(this.getUUID())) {
                                if (!isServerside) return;
                                level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                                this.removeAfterChangingDimensions();
                                return;
                            }
                            if (!injector.particles[0].passedThroughSwitch) {
                                if (!isServerside) return;
                                level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                                this.removeAfterChangingDimensions();
                                return;
                            }
                            otherSwitchDirection = injector.particles[0].switchDirection;
                            clockwise = this.facingDirection.getClockWise();
                            Direction counterClockwise = this.facingDirection.getCounterClockWise();
                            if (this.facingDirection != otherSwitchDirection && level.getBlockState(proposedMoveBlockPos.relative(this.facingDirection)).isAir()) {
                                this.switchDirection = this.facingDirection;
                                this.passedThroughSwitch = true;
                            } else if (clockwise != otherSwitchDirection && level.getBlockState(proposedMoveBlockPos.relative(clockwise)).isAir()) {
                                this.switchDirection = clockwise;
                                this.passedThroughSwitch = true;
                            } else if (counterClockwise != otherSwitchDirection && level.getBlockState(proposedMoveBlockPos.relative(counterClockwise)).isAir()) {
                                this.switchDirection = counterClockwise;
                                this.passedThroughSwitch = true;
                            } else {
                                if (!isServerside) return;
                                level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                                this.removeAfterChangingDimensions();
                                return;
                            }
                        }
                        if (this.switchDirection != this.facingDirection) {
                            this.facingDirection = this.switchDirection;
                            proposedMove = new Vec3((double)proposedMoveBlockPos.getX() + 0.5, (double)proposedMoveBlockPos.getY() + 0.5, (double)proposedMoveBlockPos.getZ() + 0.5);
                        }
                    }
                    if (!(proposedMoveState = level.getBlockState(proposedMoveBlockPos)).isAir() && !this.isSwitch(proposedMoveState) && !this.isGateway(proposedMoveState) && !this.isDiode(proposedMoveState)) break block58;
                    int amount = 0;
                    for (Direction dir : Direction.values()) {
                        if (!level.getBlockState(proposedMoveBlockPos.relative(dir)).is(NuclearScienceTags.Blocks.PARTICLE_CONTAINMENT)) continue;
                        ++amount;
                    }
                    if (amount < 4) {
                        if (!isServerside) return;
                        level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                        this.removeAfterChangingDimensions();
                        return;
                    }
                    BlockPos inFrontOfUs = proposedMoveBlockPos.relative(this.facingDirection);
                    BlockState inFrontOfUsState = level.getBlockState(inFrontOfUs);
                    boolean canPassThroughGateway = this.canPassThroughGateway(level.getBlockEntity(inFrontOfUs), inFrontOfUsState);
                    if (canPassThroughGateway && !this.passedThroughGate) {
                        level.playSound(null, proposedMoveBlockPos, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.passedThroughGate = true;
                        injector.timeSinceSpawn += 5;
                    }
                    if (!(!inFrontOfUsState.is(NuclearScienceTags.Blocks.PARTICLE_CONTAINMENT) || this.isBooster(inFrontOfUsState) || this.isSwitch(inFrontOfUsState) || canPassThroughGateway || this.canPassThroughDiode(inFrontOfUsState, this.facingDirection))) {
                        Direction checkRot = this.facingDirection.getClockWise();
                        BlockPos relative = proposedMoveBlockPos.relative(checkRot);
                        inFrontOfUsState = level.getBlockState(relative);
                        if (inFrontOfUsState.isAir() || this.isBooster(inFrontOfUsState) && !this.passedThroughSwitch || this.isSwitch(inFrontOfUsState) || this.canPassThroughGateway(level.getBlockEntity(relative), inFrontOfUsState) || this.canPassThroughDiode(inFrontOfUsState, checkRot)) {
                            this.facingDirection = checkRot;
                            proposedMove = new Vec3((double)proposedMoveBlockPos.getX() + 0.5, (double)proposedMoveBlockPos.getY() + 0.5, (double)proposedMoveBlockPos.getZ() + 0.5);
                            if (!this.passedThroughGate && !this.passedThroughSwitch) {
                                this.setSpeed(this.speed *= 0.9f);
                            }
                            break block59;
                        } else {
                            checkRot = this.facingDirection.getCounterClockWise();
                            relative = proposedMoveBlockPos.relative(checkRot);
                            inFrontOfUsState = level.getBlockState(relative);
                            if (!(inFrontOfUsState.isAir() || this.isBooster(inFrontOfUsState) || this.passedThroughSwitch || this.isSwitch(inFrontOfUsState) || this.canPassThroughGateway(level.getBlockEntity(relative), inFrontOfUsState) || this.canPassThroughDiode(inFrontOfUsState, checkRot))) {
                                if (!isServerside) return;
                                level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                                this.removeAfterChangingDimensions();
                                return;
                            }
                            this.facingDirection = checkRot;
                            if (!this.passedThroughGate && !this.passedThroughSwitch) {
                                this.setSpeed(this.speed *= 0.9f);
                            }
                            proposedMove = new Vec3((double)proposedMoveBlockPos.getX() + 0.5, (double)proposedMoveBlockPos.getY() + 0.5, (double)proposedMoveBlockPos.getZ() + 0.5);
                        }
                    }
                    break block59;
                }
                boolean checkIsBooster = this.isBooster(proposedMoveState) && startOfLoopStateIsBooster;
                boolean explode = false;
                if (checkIsBooster && (oldDir = (Direction)startOfLoopState.getValue((Property)VoltaicBlockStates.FACING)) != (nextDir = (Direction)proposedMoveState.getValue((Property)VoltaicBlockStates.FACING))) {
                    FacingDirection face = (FacingDirection)((Object)startOfLoopState.getValue((Property)NuclearScienceBlockStates.FACINGDIRECTION));
                    if (face == FacingDirection.RIGHT) {
                        oldDir = oldDir.getClockWise();
                    } else if (face == FacingDirection.LEFT) {
                        oldDir = oldDir.getCounterClockWise();
                    }
                    if (oldDir != nextDir) {
                        explode = true;
                    }
                }
                if (explode) {
                    if (!isServerside) return;
                    level.explode((Entity)this, proposedMove.x(), proposedMove.y(), proposedMove.z(), this.speed, Level.ExplosionInteraction.BLOCK);
                    this.removeAfterChangingDimensions();
                    return;
                }
            }
            this.setPos(proposedMove);
        }
    }

    public boolean isBooster(BlockState state) {
        return state.is(NuclearScienceBlocks.BLOCK_ELECTORMAGNETICBOOSTER);
    }

    public boolean isSwitch(BlockState state) {
        return state.is(NuclearScienceBlocks.BLOCK_ELECTROMAGNETICSWITCH);
    }

    public boolean isGateway(BlockState state) {
        return state.is(NuclearScienceBlocks.BLOCK_ELECTROMAGNETICGATEWAY);
    }

    public boolean isDiode(BlockState state) {
        return state.is(NuclearScienceBlocks.BLOCK_ELECTROMAGNETICDIODE);
    }

    public boolean canPassThroughGateway(BlockEntity entity, BlockState state) {
        TileElectromagneticGateway gateway;
        return this.isGateway(state) && entity instanceof TileElectromagneticGateway && (gateway = (TileElectromagneticGateway)entity).mayPassThrough(this.speed);
    }

    public boolean canPassThroughDiode(BlockState state, Direction facing) {
        return this.isDiode(state) && state.getValue((Property)VoltaicBlockStates.FACING) == facing;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        Optional optional = NbtUtils.readBlockPos((CompoundTag)compound, (String)"injector");
        optional.ifPresent(pos -> {
            this.source = pos;
        });
        this.passedThroughGate = compound.getBoolean("passedthroughgate");
        this.ticksAlive = compound.getInt("ticksalive");
        this.facingDirection = Direction.values()[compound.getInt("facing")];
        this.switchDirection = Direction.values()[compound.getInt("switch")];
        this.speed = compound.getFloat("speed");
        this.passedThroughSwitch = compound.getBoolean("passedthroughswitch");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("injector", NbtUtils.writeBlockPos((BlockPos)this.source));
        compound.putBoolean("passedthroughgate", this.passedThroughGate);
        compound.putInt("ticksalive", this.ticksAlive);
        compound.putInt("facing", this.facingDirection.ordinal());
        compound.putFloat("speed", this.speed);
        compound.putInt("switch", this.switchDirection.ordinal());
        compound.putBoolean("passedthroughswitch", this.passedThroughSwitch);
    }

    protected Component getTypeName() {
        return Component.translatable((String)"entity.particle");
    }

    public void setSpeed(float speed) {
        float sign = Math.signum(speed);
        if (speed > 2.0f || speed < -2.0f) {
            speed = 2.0f * sign;
        }
        this.speed = speed;
    }
}

