/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.common.item.ItemVoltaic;
import voltaic.registers.VoltaicDataComponentTypes;

public class ItemFrequencyCard
extends ItemVoltaic {
    public ItemFrequencyCard(Item.Properties properties, Holder<CreativeModeTab> creativeTab) {
        super(properties.stacksTo(1), creativeTab);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return super.onItemUseFirst(stack, context);
        }
        if (context.getPlayer().isShiftKeyDown()) {
            stack.remove((Supplier)VoltaicDataComponentTypes.RESOURCE_LOCATION);
            stack.remove((Supplier)VoltaicDataComponentTypes.BLOCK_POS);
        } else {
            stack.set((Supplier)VoltaicDataComponentTypes.BLOCK_POS, (Object)context.getClickedPos().above());
            stack.set((Supplier)VoltaicDataComponentTypes.RESOURCE_LOCATION, (Object)level.dimension().location());
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltips, tooltipFlag);
        if (stack.has((Supplier)VoltaicDataComponentTypes.RESOURCE_LOCATION)) {
            BlockPos pos = (BlockPos)stack.get((Supplier)VoltaicDataComponentTypes.BLOCK_POS);
            ResourceKey world = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)stack.get((Supplier)VoltaicDataComponentTypes.RESOURCE_LOCATION)));
            MutableComponent worldKey = ElectroTextUtils.dimensionExists((ResourceKey)world) ? ElectroTextUtils.dimension((ResourceKey)world, (Object[])new Object[0]) : Component.literal((String)world.location().getPath());
            tooltips.add((Component)NuclearTextUtils.tooltip("frequencycard.linked", worldKey.append(pos.toShortString())));
        } else {
            tooltips.add((Component)NuclearTextUtils.tooltip("frequencycard.notag", new Object[0]));
        }
    }
}

